/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.whylogs.core.message.DoublesMessage;
import com.whylogs.core.message.FrequentStringsSummary;
import com.whylogs.core.message.HistogramSummary;
import com.whylogs.core.message.InferredType;
import com.whylogs.core.message.NumberSummary;
import com.whylogs.core.message.QuantileSummary;
import com.whylogs.core.message.SchemaSummary;
import com.whylogs.core.message.StringsSummary;
import com.whylogs.core.message.UniqueCountSummary;
import com.whylogs.core.statistics.NumberTracker;
import com.whylogs.core.statistics.SchemaTracker;
import com.whylogs.core.statistics.datatypes.StringTracker;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Union;

public class SummaryConverters {
    public static UniqueCountSummary fromSketch(Union sketch) {
        CompactSketch result = sketch.getResult();
        return UniqueCountSummary.newBuilder().setEstimate(result.getEstimate()).setUpper(result.getUpperBound(1)).setLower(result.getLowerBound(1)).build();
    }

    public static StringsSummary fromStringTracker(StringTracker tracker) {
        FrequentStringsSummary frequentStrings;
        if (tracker == null) {
            return null;
        }
        if (tracker.getCount() == 0L) {
            return null;
        }
        UniqueCountSummary uniqueCount = SummaryConverters.fromSketch(tracker.getThetaSketch());
        StringsSummary.Builder builder = StringsSummary.newBuilder().setUniqueCount(uniqueCount).setLength(SummaryConverters.fromNumberTracker(tracker.getLength())).setTokenLength(SummaryConverters.fromNumberTracker(tracker.getTokenLength())).setCharPosTracker(tracker.getCharPosTracker().toSummary());
        if (uniqueCount.getEstimate() < 100.0 && (frequentStrings = SummaryConverters.fromStringSketch(tracker.getItems())) != null) {
            builder.setFrequent(frequentStrings);
        }
        return builder.build();
    }

    public static SchemaSummary.Builder fromSchemaTracker(SchemaTracker tracker) {
        Map<InferredType.Type, Long> typeCounts = tracker.getTypeCounts();
        Map<String, Long> typeCountWithNames = typeCounts.entrySet().stream().collect(Collectors.toMap(e -> ((InferredType.Type)((Object)((Object)e.getKey()))).name(), Map.Entry::getValue));
        return SchemaSummary.newBuilder().setInferredType(tracker.getInferredType()).putAllTypeCounts(typeCountWithNames);
    }

    public static NumberSummary fromNumberTracker(NumberTracker numberTracker) {
        double max;
        double min;
        double mean;
        if (numberTracker == null) {
            return null;
        }
        long count = numberTracker.getVariance().getCount();
        if (count == 0L) {
            return null;
        }
        double stddev = numberTracker.getVariance().stddev();
        DoublesMessage.Builder doubles = numberTracker.getDoubles().toProtobuf();
        if (doubles.getCount() > 0L) {
            mean = doubles.getSum() / (double)doubles.getCount();
            min = doubles.getMin();
            max = doubles.getMax();
        } else {
            mean = numberTracker.getLongs().getMean();
            min = numberTracker.getLongs().getMin();
            max = numberTracker.getLongs().getMax();
        }
        HistogramSummary histogram = SummaryConverters.fromUpdateDoublesSketch(numberTracker.getHistogram());
        CompactSketch result = numberTracker.getThetaSketch().getResult();
        UniqueCountSummary.Builder uniqueCountSummary = UniqueCountSummary.newBuilder().setEstimate(result.getEstimate()).setLower(result.getLowerBound(1)).setUpper(result.getUpperBound(1));
        double[] QUANTILES = new double[]{0.0, 0.01, 0.05, 0.25, 0.5, 0.75, 0.95, 0.99, 1.0};
        Double[] boxedQuantiles = ArrayUtils.toObject((double[])QUANTILES);
        float[] qvals = numberTracker.getHistogram().getQuantiles(QUANTILES);
        int len = qvals.length;
        Double[] boxedQvals = new Double[len];
        for (int index = 0; index < qvals.length; ++index) {
            boxedQvals[index] = qvals[index];
        }
        QuantileSummary.Builder quantileSummary = QuantileSummary.newBuilder().addAllQuantiles(Arrays.asList(boxedQuantiles)).addAllQuantileValues(Arrays.asList(boxedQvals));
        return NumberSummary.newBuilder().setCount(count).setStddev(stddev).setMin(min).setMax(max).setMean(mean).setHistogram(histogram).setUniqueCount(uniqueCountSummary).setQuantiles(quantileSummary).setIsDiscrete(false).build();
    }

    public static FrequentStringsSummary fromStringSketch(ItemsSketch<String> sketch) {
        ItemsSketch.Row[] frequentItems = sketch.getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
        if (frequentItems.length == 0) {
            return null;
        }
        List result = Stream.of(frequentItems).map(SummaryConverters::toFrequentItem).collect(Collectors.toList());
        return FrequentStringsSummary.newBuilder().addAllItems(result).build();
    }

    private static FrequentStringsSummary.FrequentItem toFrequentItem(ItemsSketch.Row<String> row) {
        return FrequentStringsSummary.FrequentItem.newBuilder().setValue((String)row.getItem()).setEstimate(row.getEstimate()).build();
    }

    public static HistogramSummary fromUpdateDoublesSketch(KllFloatsSketch sketch) {
        return SummaryConverters.fromUpdateDoublesSketch(sketch, 30);
    }

    public static HistogramSummary fromUpdateDoublesSketch(KllFloatsSketch sketch, float[] splitpoints) {
        return SummaryConverters.fromUpdateDoublesSketch(sketch, 0, splitpoints);
    }

    public static HistogramSummary fromUpdateDoublesSketch(KllFloatsSketch sketch, int nBins) {
        return SummaryConverters.fromUpdateDoublesSketch(sketch, nBins, null);
    }

    private static HistogramSummary fromUpdateDoublesSketch(KllFloatsSketch sketch, int nBins, @Nullable float[] splitPoints) {
        int n = splitPoints != null ? splitPoints.length + 1 : (nBins = nBins > 0 ? nBins : 30);
        if (nBins < 2) {
            throw new IllegalArgumentException("at least 2 bins expected");
        }
        HistogramSummary.Builder builder = HistogramSummary.newBuilder();
        if (sketch.isEmpty()) {
            return builder.build();
        }
        long n2 = sketch.getN();
        float start = SummaryConverters.noNan(sketch.getMinValue());
        float end = SummaryConverters.noNan(sketch.getMaxValue());
        builder.setN(n2).setMin(start).setMax(end);
        float width = (end - start) / (float)nBins;
        width = Math.max(width, Math.ulp(start));
        builder.setWidth(width);
        if (splitPoints != null) {
            builder.addBins(sketch.getMinValue());
            for (float splitPoint : splitPoints) {
                builder.addBins(splitPoint);
            }
            builder.addBins(sketch.getMaxValue());
        } else {
            int n3 = nBins - 1;
            splitPoints = new float[n3];
            builder.addBins(start);
            for (int i = 0; i < n3; ++i) {
                splitPoints[i] = start + (float)(i + 1) * width;
                builder.addBins(splitPoints[i]);
            }
            builder.addBins(end);
        }
        for (double v : sketch.getPMF(splitPoints)) {
            builder.addCounts(Math.round(SummaryConverters.noNan(v) * (double)n2));
        }
        return builder.build();
    }

    public static double noNan(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return 0.0;
        }
        return value;
    }

    public static float noNan(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            return 0.0f;
        }
        return value;
    }
}

