/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics.datatypes;

import com.whylogs.core.message.DoublesMessage;
import com.whylogs.core.statistics.datatypes.LongTracker;

public class DoubleTracker {
    private double min;
    private double max;
    private double sum;
    private long count;

    public DoubleTracker() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.sum = 0.0;
        this.count = 0L;
    }

    public void addLongs(LongTracker longs) {
        if (longs != null && longs.getCount() != 0L) {
            this.min = longs.getMin();
            this.max = longs.getMax();
            this.sum = longs.getSum();
            this.count = longs.getCount();
        }
    }

    public double getMean() {
        return this.sum / (double)this.count;
    }

    public void update(double value) {
        if (value > this.max) {
            this.max = value;
        }
        if (value < this.min) {
            this.min = value;
        }
        ++this.count;
        this.sum += value;
    }

    public void add(DoubleTracker other) {
        if (other == null) {
            return;
        }
        if (other.min < this.min) {
            this.min = other.min;
        }
        if (other.max > this.max) {
            this.max = other.max;
        }
        this.sum += other.sum;
        this.count += other.count;
    }

    public DoubleTracker merge(DoubleTracker other) {
        DoubleTracker thisCopy = new DoubleTracker(this.min, this.max, this.sum, this.count);
        thisCopy.add(other);
        return thisCopy;
    }

    public DoublesMessage.Builder toProtobuf() {
        return DoublesMessage.newBuilder().setCount(this.count).setSum(this.sum).setMin(this.min).setMax(this.max);
    }

    public static DoubleTracker fromProtobuf(DoublesMessage message) {
        DoubleTracker tracker = new DoubleTracker();
        tracker.count = message.getCount();
        tracker.max = message.getMax();
        tracker.min = message.getMin();
        tracker.sum = message.getSum();
        return tracker;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleTracker)) {
            return false;
        }
        DoubleTracker other = (DoubleTracker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMin(), other.getMin()) != 0) {
            return false;
        }
        if (Double.compare(this.getMax(), other.getMax()) != 0) {
            return false;
        }
        if (Double.compare(this.getSum(), other.getSum()) != 0) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DoubleTracker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $min = Double.doubleToLongBits(this.getMin());
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $max = Double.doubleToLongBits(this.getMax());
        result = result * 59 + (int)($max >>> 32 ^ $max);
        long $sum = Double.doubleToLongBits(this.getSum());
        result = result * 59 + (int)($sum >>> 32 ^ $sum);
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        return result;
    }

    public String toString() {
        return "DoubleTracker(min=" + this.getMin() + ", max=" + this.getMax() + ", sum=" + this.getSum() + ", count=" + this.getCount() + ")";
    }

    private DoubleTracker(double min, double max, double sum, long count) {
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.count = count;
    }
}

