package app.cash.sqldelight.dialects.sqlite_3_24.grammar

import app.cash.sqldelight.dialects.sqlite_3_24.grammar.psi.SqliteTypes
import com.alecstrong.sql.psi.core.SqlParserUtil
import com.intellij.lang.ASTNode
import com.intellij.lang.PsiBuilder
import com.intellij.lang.parser.GeneratedParserUtilBase
import com.intellij.psi.PsiElement
import java.lang.AssertionError
import kotlin.Boolean
import kotlin.Int
import kotlin.Unit
import kotlin.jvm.JvmStatic

public object SqliteParserUtil : GeneratedParserUtilBase() {
  public var createElement: (ASTNode) -> PsiElement = { SqliteTypes.Factory.createElement(it) }

  public var insert_stmt: GeneratedParserUtilBase.Parser? = null

  public var upsert_clause: GeneratedParserUtilBase.Parser? = null

  public var upsert_conflict_target: GeneratedParserUtilBase.Parser? = null

  public var upsert_do_update: GeneratedParserUtilBase.Parser? = null

  @JvmStatic
  public fun insertStmtExt(
    builder: PsiBuilder,
    level: Int,
    insert_stmt: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.insert_stmt ?: insert_stmt).parse(builder, level)

  @JvmStatic
  public fun upsertClauseExt(
    builder: PsiBuilder,
    level: Int,
    upsert_clause: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.upsert_clause ?: upsert_clause).parse(builder, level)

  @JvmStatic
  public fun upsertConflictTargetExt(
    builder: PsiBuilder,
    level: Int,
    upsert_conflict_target: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.upsert_conflict_target ?: upsert_conflict_target).parse(builder, level)

  @JvmStatic
  public fun upsertDoUpdateExt(
    builder: PsiBuilder,
    level: Int,
    upsert_do_update: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.upsert_do_update ?: upsert_do_update).parse(builder, level)

  public fun reset(): Unit {
    createElement = { SqliteTypes.Factory.createElement(it) }
    insert_stmt = null
    upsert_clause = null
    upsert_conflict_target = null
    upsert_do_update = null
  }

  public fun overrideSqlParser(): Unit {
    SqlParserUtil.insert_stmt = Parser { psiBuilder, i -> insert_stmt?.parse(psiBuilder, i) ?:
        SqliteParser.insert_stmt_real(psiBuilder, i) }
    val currentCreateElement = SqlParserUtil.createElement
    SqlParserUtil.createElement = {
      try {
        createElement(it)
      } catch(e: AssertionError) {
        currentCreateElement(it)
      }
    }
  }
}
