/*
 * Decompiled with CFR 0.152.
 */
package wisp.deployment;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lwisp/deployment/Deployment;", "", "name", "", "isProduction", "", "isStaging", "isTest", "isLocalDevelopment", "(Ljava/lang/String;ZZZZ)V", "isFake", "()Z", "isReal", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "mapToEnvironmentName", "toString", "wisp-deployment"})
public final class Deployment {
    @NotNull
    private final String name;
    private final boolean isProduction;
    private final boolean isStaging;
    private final boolean isTest;
    private final boolean isLocalDevelopment;

    @JvmOverloads
    public Deployment(@NotNull String name, boolean isProduction, boolean isStaging, boolean isTest, boolean isLocalDevelopment) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.isProduction = isProduction;
        this.isStaging = isStaging;
        this.isTest = isTest;
        this.isLocalDevelopment = isLocalDevelopment;
        if (this.isProduction) {
            if (!(!this.isStaging && !this.isTest && !this.isLocalDevelopment)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        } else if (this.isStaging) {
            if (!(!this.isProduction && !this.isTest && !this.isLocalDevelopment)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        } else if (this.isTest) {
            if (!(!this.isProduction && !this.isStaging && !this.isLocalDevelopment)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        } else if (this.isLocalDevelopment && !(!this.isProduction && !this.isStaging && !this.isTest)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ Deployment(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        this(string, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isProduction() {
        return this.isProduction;
    }

    public final boolean isStaging() {
        return this.isStaging;
    }

    public final boolean isTest() {
        return this.isTest;
    }

    public final boolean isLocalDevelopment() {
        return this.isLocalDevelopment;
    }

    public final boolean isReal() {
        return !this.isFake();
    }

    public final boolean isFake() {
        return this.isTest || this.isLocalDevelopment;
    }

    @NotNull
    public final String mapToEnvironmentName() {
        return this.isProduction ? "production" : (this.isStaging ? "staging" : (this.isTest ? "testing" : "development"));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final boolean component2() {
        return this.isProduction;
    }

    public final boolean component3() {
        return this.isStaging;
    }

    public final boolean component4() {
        return this.isTest;
    }

    public final boolean component5() {
        return this.isLocalDevelopment;
    }

    @NotNull
    public final Deployment copy(@NotNull String name, boolean isProduction, boolean isStaging, boolean isTest, boolean isLocalDevelopment) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Deployment(name, isProduction, isStaging, isTest, isLocalDevelopment);
    }

    public static /* synthetic */ Deployment copy$default(Deployment deployment, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 1) != 0) {
            string = deployment.name;
        }
        if ((n & 2) != 0) {
            bl = deployment.isProduction;
        }
        if ((n & 4) != 0) {
            bl2 = deployment.isStaging;
        }
        if ((n & 8) != 0) {
            bl3 = deployment.isTest;
        }
        if ((n & 0x10) != 0) {
            bl4 = deployment.isLocalDevelopment;
        }
        return deployment.copy(string, bl, bl2, bl3, bl4);
    }

    @NotNull
    public String toString() {
        return "Deployment(name=" + this.name + ", isProduction=" + this.isProduction + ", isStaging=" + this.isStaging + ", isTest=" + this.isTest + ", isLocalDevelopment=" + this.isLocalDevelopment + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + Boolean.hashCode(this.isProduction);
        result = result * 31 + Boolean.hashCode(this.isStaging);
        result = result * 31 + Boolean.hashCode(this.isTest);
        result = result * 31 + Boolean.hashCode(this.isLocalDevelopment);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Deployment)) {
            return false;
        }
        Deployment deployment = (Deployment)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)deployment.name)) {
            return false;
        }
        if (this.isProduction != deployment.isProduction) {
            return false;
        }
        if (this.isStaging != deployment.isStaging) {
            return false;
        }
        if (this.isTest != deployment.isTest) {
            return false;
        }
        return this.isLocalDevelopment == deployment.isLocalDevelopment;
    }

    @JvmOverloads
    public Deployment(@NotNull String name, boolean isProduction, boolean isStaging, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, isProduction, isStaging, isTest, false, 16, null);
    }

    @JvmOverloads
    public Deployment(@NotNull String name, boolean isProduction, boolean isStaging) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, isProduction, isStaging, false, false, 24, null);
    }

    @JvmOverloads
    public Deployment(@NotNull String name, boolean isProduction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, isProduction, false, false, false, 28, null);
    }

    @JvmOverloads
    public Deployment(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, false, false, false, false, 30, null);
    }
}

