/*
 * Decompiled with CFR 0.152.
 */
package wisp.resources;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.resources.ResourceLoader;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lwisp/resources/ClasspathResourceLoaderBackend;", "Lwisp/resources/ResourceLoader$Backend;", "()V", "SCHEME", "", "exists", "", "path", "jarFile", "Ljava/io/File;", "jarFileUrl", "jarFileChildren", "", "file", "pathPrefix", "list", "", "open", "Lokio/BufferedSource;", "wisp-resource-loader"})
public final class ClasspathResourceLoaderBackend
extends ResourceLoader.Backend {
    @NotNull
    public static final ClasspathResourceLoaderBackend INSTANCE = new ClasspathResourceLoaderBackend();
    @NotNull
    public static final String SCHEME = "classpath:";

    private ClasspathResourceLoaderBackend() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> list(@NotNull String path) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String urlString;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String checkPath = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)path, (CharSequence)"/"), (CharSequence)"/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Set result = new LinkedHashSet();
        Enumeration<URL> enumeration = classLoader.getResources(checkPath);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"classLoader.getResources(checkPath)");
        Object object = CollectionsKt.iterator(enumeration);
        while (object.hasNext()) {
            File file;
            URL url = (URL)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)url.toString(), (String)"url.toString()");
            if (StringsKt.startsWith$default((String)urlString, (String)"file:", (boolean)false, (int)2, null)) {
                file = new File(url.toURI());
                Collection collection = result;
                Object[] objectArray = file.list();
                if (objectArray == null) {
                    objectArray = new String[]{};
                }
                CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
                continue;
            }
            if (!StringsKt.startsWith$default((String)urlString, (String)"jar:file:", (boolean)false, (int)2, null)) continue;
            file = this.jarFile(urlString);
            CollectionsKt.addAll((Collection)result, (Iterable)this.jarFileChildren(file, checkPath + "/"));
        }
        object = result;
        boolean $i$f$filter = false;
        urlString = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.endsWith$default((String)it, (String)".class", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("/" + checkPath + "/" + it);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final File jarFile(String jarFileUrl) {
        int suffixStart = StringsKt.lastIndexOf$default((CharSequence)jarFileUrl, (String)"!", (int)0, (boolean)false, (int)6, null);
        if (suffixStart == -1) {
            suffixStart = jarFileUrl.length();
        }
        String string = jarFileUrl.substring("jar:file:".length(), suffixStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return new File(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> jarFileChildren(File file, String pathPrefix) {
        Set result = new LinkedHashSet();
        Closeable closeable = new JarFile(file);
        Throwable throwable = null;
        try {
            JarFile jarFile = (JarFile)closeable;
            boolean bl = false;
            Iterator<JarEntry> iterator = jarFile.entries().asIterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"jarFile.entries().asIterator()");
            Iterator<JarEntry> iterator2 = iterator;
            while (iterator2.hasNext()) {
                JarEntry entry = iterator2.next();
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                if (!StringsKt.startsWith$default((String)string, (String)pathPrefix, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)entry.getName(), (Object)pathPrefix)) continue;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                int endIndex = StringsKt.indexOf$default((CharSequence)string2, (String)"/", (int)pathPrefix.length(), (boolean)false, (int)4, null);
                if (endIndex == -1) {
                    endIndex = entry.getName().length();
                }
                Collection collection = result;
                String string3 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                String string4 = string3;
                int n = pathPrefix.length();
                String string5 = string4.substring(n, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string4 = string5;
                collection.add(string4);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return result;
    }

    @Override
    @Nullable
    public BufferedSource open(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(StringsKt.removePrefix((String)path, (CharSequence)"/"));
        if (inputStream == null) {
            return null;
        }
        InputStream resourceAsStream = inputStream;
        return Okio.buffer((Source)Okio.source((InputStream)resourceAsStream));
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResource(StringsKt.removePrefix((String)path, (CharSequence)"/")) != null;
    }
}

