/*
 * Decompiled with CFR 0.152.
 */
package wisp.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import mu.KLogger;
import mu.KotlinLogging;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.resources.ResourceLoader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\tH\u0002J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0004H\u0016J3\u0010'\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00042!\u0010(\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0007\u001a)\u0012\u0004\u0012\u00020\t\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R8\u0010\u0017\u001a,\u0012(\u0012&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\t0\t \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\t0\t\u0018\u00010\u00190\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lwisp/resources/FilesystemLoaderBackend;", "Lwisp/resources/ResourceLoader$Backend;", "()V", "SCHEME", "", "logger", "Lmu/KLogger;", "resourceChangedListeners", "", "Ljava/nio/file/Path;", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "address", "", "threadGroup", "Ljava/lang/ThreadGroup;", "watchedDirectoryPathCount", "", "watchedDirectoryThreads", "Ljava/lang/Thread;", "getWatchedDirectoryThreads$wisp_resource_loader", "()Ljava/util/Map;", "watchedEventKinds", "", "Ljava/nio/file/WatchEvent$Kind;", "kotlin.jvm.PlatformType", "watchedPaths", "", "watcher", "Ljava/nio/file/WatchService;", "exists", "", "path", "open", "Lokio/BufferedSource;", "startWatcherThread", "directory", "unwatch", "watch", "resourceChangedListener", "wisp-resource-loader"})
public final class FilesystemLoaderBackend
extends ResourceLoader.Backend {
    @NotNull
    public static final FilesystemLoaderBackend INSTANCE = new FilesystemLoaderBackend();
    @NotNull
    private static final KLogger logger;
    @NotNull
    public static final String SCHEME = "filesystem:";
    @NotNull
    private static final WatchService watcher;
    @NotNull
    private static final ThreadGroup threadGroup;
    @NotNull
    private static final Map<Path, Thread> watchedDirectoryThreads;
    @NotNull
    private static final Map<Path, Integer> watchedDirectoryPathCount;
    @NotNull
    private static final Set<Path> watchedPaths;
    @NotNull
    private static Map<Path, Function1<String, Unit>> resourceChangedListeners;
    @NotNull
    private static final List<WatchEvent.Kind<Path>> watchedEventKinds;

    private FilesystemLoaderBackend() {
    }

    @NotNull
    public final Map<Path, Thread> getWatchedDirectoryThreads$wisp_resource_loader() {
        return watchedDirectoryThreads;
    }

    @Override
    @Nullable
    public BufferedSource open(@NotNull String path) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        try {
            bufferedSource = Okio.buffer((Source)Okio.source((File)file));
        }
        catch (FileNotFoundException e) {
            bufferedSource = null;
        }
        return bufferedSource;
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new File(path).exists();
    }

    @Override
    public void watch(@NotNull String path, @NotNull Function1<? super String, Unit> resourceChangedListener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(resourceChangedListener, (String)"resourceChangedListener");
        Path file = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        watchedPaths.add(file);
        resourceChangedListeners.put(file, resourceChangedListener);
        Path directory = file.getParent();
        Map<Path, Integer> map = watchedDirectoryPathCount;
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"directory");
        Path path2 = directory;
        Integer n = watchedDirectoryPathCount.get(directory);
        Integer n2 = n != null ? n + 1 : 1;
        map.put(path2, n2);
        Thread thread = watchedDirectoryThreads.get(directory);
        boolean bl = thread != null ? thread.isAlive() : false;
        if (bl) {
            return;
        }
        logger.info((Function0)new Function0<Object>(directory){
            final /* synthetic */ Path $directory;
            {
                this.$directory = $directory;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Registering watcher on " + this.$directory;
            }
        });
        Collection $this$toTypedArray$iv = watchedEventKinds;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        WatchEvent.Kind[] kindArray = thisCollection$iv.toArray(new WatchEvent.Kind[0]);
        if (kindArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        directory.register(watcher, kindArray, new WatchEvent.Modifier[0]);
        watchedDirectoryThreads.put(directory, this.startWatcherThread(directory));
    }

    private final Thread startWatcherThread(Path directory) {
        Thread thread = new Thread(threadGroup, () -> FilesystemLoaderBackend.startWatcherThread$lambda-2(directory));
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    @Override
    public void unwatch(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path file = Paths.get(path, new String[0]);
        Path directory = file.getParent();
        Integer n = watchedDirectoryPathCount.get(directory);
        int newDirectoryPathCount = n != null ? n - 1 : 0;
        Integer n2 = newDirectoryPathCount;
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"directory");
        watchedDirectoryPathCount.put(directory, n2);
        Thread thread = watchedDirectoryThreads.get(directory);
        if (thread != null) {
            Thread it = thread;
            boolean bl = false;
            if (it.isAlive() && newDirectoryPathCount == 0) {
                logger.info((Function0)new Function0<Object>(directory){
                    final /* synthetic */ Path $directory;
                    {
                        this.$directory = $directory;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Removing watcher on " + this.$directory;
                    }
                });
                it.interrupt();
                watchedDirectoryPathCount.remove(directory);
                watchedDirectoryThreads.remove(directory);
            }
        }
        watchedPaths.remove(file);
        resourceChangedListeners.remove(file);
    }

    private static final void startWatcherThread$lambda-2(Path $directory) {
        Intrinsics.checkNotNullParameter((Object)$directory, (String)"$directory");
        try {
            while (true) {
                Object v1;
                WatchKey key;
                block8: {
                    key = watcher.take();
                    List<WatchEvent<?>> list = key.pollEvents();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"key.pollEvents()");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        WatchEvent event = (WatchEvent)element$iv;
                        boolean bl = false;
                        if (!CollectionsKt.contains((Iterable)watchedEventKinds, event.kind())) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                WatchEvent watchEvent = v1;
                if (watchEvent != null) {
                    WatchEvent event = watchEvent;
                    boolean bl = false;
                    WatchEvent ev = event;
                    Object t = ev.context();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"ev.context()");
                    Path fileName = (Path)t;
                    Path fullPathFile = $directory.resolve(fileName);
                    if (watchedPaths.contains(fullPathFile)) {
                        String address = SCHEME + fullPathFile;
                        Function1<String, Unit> function1 = resourceChangedListeners.get(fullPathFile);
                        if (function1 != null) {
                            function1.invoke((Object)address);
                        }
                    }
                }
                key.reset();
            }
        }
        catch (InterruptedException key) {
        }
        catch (Exception e) {
            logger.warn("Problem while watching " + $directory, (Throwable)e);
        }
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(FilesystemLoaderBackend.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
        WatchService watchService = FileSystems.getDefault().newWatchService();
        Intrinsics.checkNotNullExpressionValue((Object)watchService, (String)"getDefault().newWatchService()");
        watcher = watchService;
        threadGroup = new ThreadGroup("FilesystemLoader");
        watchedDirectoryThreads = new LinkedHashMap();
        watchedDirectoryPathCount = new LinkedHashMap();
        watchedPaths = new LinkedHashSet();
        resourceChangedListeners = new LinkedHashMap();
        Object[] objectArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
        watchedEventKinds = CollectionsKt.listOf((Object[])objectArray);
    }
}

