/*
 * Decompiled with CFR 0.152.
 */
package wisp.resources;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.resources.ResourceLoader;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J3\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00052!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006H\u0016R5\u0010\u0003\u001a)\u0012\u0004\u0012\u00020\u0005\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lwisp/resources/MemoryResourceLoaderBackend;", "Lwisp/resources/ResourceLoader$Backend;", "()V", "resourceChangedListeners", "", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "address", "", "resources", "Ljava/util/TreeMap;", "Lokio/ByteString;", "all", "", "exists", "", "path", "open", "Lokio/BufferedSource;", "put", "data", "resourceChanged", "scheme", "unwatch", "watch", "resourceChangedListener", "Companion", "wisp-resource-loader"})
public final class MemoryResourceLoaderBackend
extends ResourceLoader.Backend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TreeMap<String, ByteString> resources = new TreeMap();
    @NotNull
    private Map<String, Function1<String, Unit>> resourceChangedListeners = new LinkedHashMap();
    @NotNull
    public static final String SCHEME = "memory:";

    @Override
    @Nullable
    public BufferedSource open(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ByteString byteString = this.resources.get(path);
        if (byteString == null) {
            return null;
        }
        ByteString resource = byteString;
        return (BufferedSource)new Buffer().write(resource);
    }

    @Override
    public void put(@NotNull String path, @NotNull ByteString data) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ((Map)this.resources).put(path, data);
        this.resourceChanged(SCHEME, path);
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.resources.get(path) != null;
    }

    @Override
    @NotNull
    public Set<String> all() {
        Set<String> set = this.resources.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"resources.keys");
        return set;
    }

    @Override
    public void watch(@NotNull String path, @NotNull Function1<? super String, Unit> resourceChangedListener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(resourceChangedListener, (String)"resourceChangedListener");
        this.resourceChangedListeners.put(path, resourceChangedListener);
    }

    @Override
    public void unwatch(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.resourceChangedListeners.remove(path);
    }

    public final void resourceChanged(@NotNull String scheme, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Function1<String, Unit> resourceChangedListener = this.resourceChangedListeners.get(path);
        if (resourceChangedListener != null) {
            resourceChangedListener.invoke((Object)(scheme + path));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lwisp/resources/MemoryResourceLoaderBackend$Companion;", "", "()V", "SCHEME", "", "wisp-resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

