/*
 * Decompiled with CFR 0.152.
 */
package wisp.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\t\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lwisp/time/FakeClock;", "Ljava/time/Clock;", "epochMillis", "", "zone", "Ljava/time/ZoneId;", "(JLjava/time/ZoneId;)V", "millis", "Ljava/util/concurrent/atomic/AtomicLong;", "add", "d", "Ljava/time/Duration;", "p", "Ljava/time/Period;", "n", "unit", "Ljava/util/concurrent/TimeUnit;", "getZone", "instant", "Ljava/time/Instant;", "setNow", "", "withZone", "wisp-time-testing"})
public class FakeClock
extends Clock {
    @NotNull
    private final ZoneId zone;
    @NotNull
    private final AtomicLong millis;

    public FakeClock(long epochMillis, @NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        this.zone = zone;
        this.millis = new AtomicLong(epochMillis);
    }

    public /* synthetic */ FakeClock(long l, ZoneId zoneId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = Instant.parse("2018-01-01T00:00:00Z").toEpochMilli();
        }
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.of("UTC");
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"of(\"UTC\")");
            zoneId = zoneId2;
        }
        this(l, zoneId);
    }

    @Override
    @NotNull
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    @NotNull
    public Clock withZone(@NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return new FakeClock(this.millis.get(), zone);
    }

    @Override
    @NotNull
    public Instant instant() {
        Instant instant = Instant.ofEpochMilli(this.millis.get()).atZone(this.zone).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(millis.get(\u2026.atZone(zone).toInstant()");
        return instant;
    }

    public final long add(@NotNull Duration d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return this.millis.addAndGet(d.toMillis());
    }

    public final long add(@NotNull Period p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.millis.updateAndGet(arg_0 -> FakeClock.add$lambda$0(this, p, arg_0));
    }

    public final long add(long n, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.millis.addAndGet(TimeUnit.MILLISECONDS.convert(n, unit));
    }

    public final void setNow(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        this.millis.set(instant.toEpochMilli());
    }

    private static final long add$lambda$0(FakeClock this$0, Period $p, long millis) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$p, (String)"$p");
        return Instant.ofEpochMilli(millis).atZone(this$0.zone).plus($p).toInstant().toEpochMilli();
    }

    public FakeClock() {
        this(0L, null, 3, null);
    }
}

