package app.iapush.repositories.redirections

import app.iapush.models.redirections.CreateRedirectionPayload
import app.iapush.models.redirections.Redirection
import app.iapush.models.redirections.UpdateRedirectionPayload
import dev.kaccelero.models.UUID

interface IRedirectionRemoteRepository {

    suspend fun list(appId: UUID, userId: UUID): List<Redirection>
    suspend fun get(id: UUID, appId: UUID, userId: UUID): Redirection?
    suspend fun create(payload: CreateRedirectionPayload, appId: UUID, userId: UUID): Redirection?
    suspend fun update(id: UUID, appId: UUID, payload: UpdateRedirectionPayload, userId: UUID): Redirection?
    suspend fun delete(id: UUID, appId: UUID, userId: UUID): Boolean

}
