package app.iapush.repositories.users

import app.iapush.client.IIAPushClient
import app.iapush.models.users.CreateUserPayload
import app.iapush.models.users.User
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIModelRemoteRepository
import io.ktor.util.reflect.*

class UsersRemoteRepository(
    client: IIAPushClient,
) : APIModelRemoteRepository<User, UUID, CreateUserPayload, Unit>(
    typeInfo<User>(),
    typeInfo<CreateUserPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<User>>(),
    client,
    prefix = "/api/v1"
), IUsersRemoteRepository {

    override suspend fun get(id: UUID): User? = get(id, null)

    override suspend fun delete(id: UUID) = delete(id, null)

}
