/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.rippled.api.client;

import app.keyconnect.rippled.api.client.config.PublicRippledClientConfig;
import app.keyconnect.rippled.api.client.model.AccountInfoRequest;
import app.keyconnect.rippled.api.client.model.AccountInfoRequestParam;
import app.keyconnect.rippled.api.client.model.AccountInfoResponse;
import app.keyconnect.rippled.api.client.model.AccountTransactionItem;
import app.keyconnect.rippled.api.client.model.AccountTransactionMarker;
import app.keyconnect.rippled.api.client.model.AccountTransactionRequest;
import app.keyconnect.rippled.api.client.model.AccountTransactionRequestParam;
import app.keyconnect.rippled.api.client.model.AccountTransactionResponse;
import app.keyconnect.rippled.api.client.model.FeeRequest;
import app.keyconnect.rippled.api.client.model.FeeResponse;
import app.keyconnect.rippled.api.client.model.ServerInfoRequest;
import app.keyconnect.rippled.api.client.model.ServerInfoResponse;
import app.keyconnect.rippled.api.client.model.SubmitTransactionRequest;
import app.keyconnect.rippled.api.client.model.SubmitTransactionRequestParam;
import app.keyconnect.rippled.api.client.model.SubmitTransactionResponse;
import app.keyconnect.rippled.api.client.model.TransactionRequest;
import app.keyconnect.rippled.api.client.model.TransactionRequestParam;
import app.keyconnect.rippled.api.client.model.TransactionResponse;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.web.client.RestTemplate;

public class PublicRippledClient {
    private final RestTemplate restTemplate;
    private final PublicRippledClientConfig config;

    public PublicRippledClient(RestTemplate restTemplate, PublicRippledClientConfig config) {
        this.restTemplate = restTemplate;
        this.config = config;
    }

    public ServerInfoResponse getServerInfo() {
        return (ServerInfoResponse)this.restTemplate.postForObject(this.config.getJsonRpcEndpoint(), (Object)new ServerInfoRequest(), ServerInfoResponse.class, new Object[0]);
    }

    public FeeResponse getFee() {
        return (FeeResponse)this.restTemplate.postForObject(this.config.getJsonRpcEndpoint(), (Object)new FeeRequest(), FeeResponse.class, new Object[0]);
    }

    public AccountInfoResponse getAccountInfo(String address) {
        AccountInfoRequest request = new AccountInfoRequest().addParamsItem(new AccountInfoRequestParam().account(address));
        return (AccountInfoResponse)this.restTemplate.postForObject(this.config.getJsonRpcEndpoint(), (Object)request, AccountInfoResponse.class, new Object[0]);
    }

    public AccountTransactionResponse getAccountTransactions(String address, int limit) {
        return this.getAccountTransactions(address, limit, -1, -1, null);
    }

    public AccountTransactionResponse getAccountTransactions(String address, int limit, @Nullable AccountTransactionMarker marker) {
        return this.getAccountTransactions(address, limit, null, null, marker);
    }

    public List<AccountTransactionItem> getAllTransactions(String address) {
        LinkedList<AccountTransactionItem> transactions = new LinkedList<AccountTransactionItem>();
        AccountTransactionResponse response = this.getAccountTransactions(address, 25, -1, -1, null);
        transactions.addAll(response.getResult().getTransactions());
        if (response.getResult().getMarker() == null) {
            return transactions;
        }
        AccountTransactionMarker marker = response.getResult().getMarker();
        while (marker != null) {
            response = this.getAccountTransactions(address, 25, null, null, marker);
            marker = response.getResult().getMarker();
        }
        return transactions;
    }

    public AccountTransactionResponse getAccountTransactions(String address, int limit, @Nullable Integer ledgerIndexMax, @Nullable Integer ledgerIndexMin, @Nullable AccountTransactionMarker marker) {
        AccountTransactionRequestParam accountTransactionRequestParam = new AccountTransactionRequestParam().account(address).limit(limit).ledgerIndexMax(ledgerIndexMax).ledgerIndexMin(ledgerIndexMin).marker(marker);
        AccountTransactionRequest request = new AccountTransactionRequest().addParamsItem(accountTransactionRequestParam);
        return (AccountTransactionResponse)this.restTemplate.postForObject(this.config.getJsonRpcEndpoint(), (Object)request, AccountTransactionResponse.class, new Object[0]);
    }

    public TransactionResponse getTransaction(String hash) {
        TransactionRequest transactionRequest = new TransactionRequest().addParamsItem(new TransactionRequestParam().transaction(hash));
        return (TransactionResponse)this.restTemplate.postForObject(this.config.getJsonRpcEndpoint(), (Object)transactionRequest, TransactionResponse.class, new Object[0]);
    }

    public SubmitTransactionResponse submitTransaction(String blob) {
        SubmitTransactionRequest submitTransactionRequest = new SubmitTransactionRequest().addParamsItem(new SubmitTransactionRequestParam().txBlob(blob));
        return (SubmitTransactionResponse)this.restTemplate.postForObject(this.config.getJsonRpcEndpoint(), (Object)submitTransactionRequest, SubmitTransactionResponse.class, new Object[0]);
    }

    private String toJson(Object object) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }
}

