/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.rippled.api.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"Account", "Balance", "Flags", "LedgerEntryType", "OwnerCount", "PreviousTxnID", "PreviousTxnLgrSeq", "Sequence", "index"})
@JsonTypeName(value="AccountData")
public class AccountData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCOUNT = "Account";
    private String account;
    public static final String JSON_PROPERTY_BALANCE = "Balance";
    private String balance;
    public static final String JSON_PROPERTY_FLAGS = "Flags";
    private BigDecimal flags;
    public static final String JSON_PROPERTY_LEDGER_ENTRY_TYPE = "LedgerEntryType";
    private String ledgerEntryType;
    public static final String JSON_PROPERTY_OWNER_COUNT = "OwnerCount";
    private BigDecimal ownerCount;
    public static final String JSON_PROPERTY_PREVIOUS_TXN_I_D = "PreviousTxnID";
    private String previousTxnID;
    public static final String JSON_PROPERTY_PREVIOUS_TXN_LGR_SEQ = "PreviousTxnLgrSeq";
    private BigDecimal previousTxnLgrSeq;
    public static final String JSON_PROPERTY_SEQUENCE = "Sequence";
    private BigDecimal sequence;
    public static final String JSON_PROPERTY_INDEX = "index";
    private String index;

    public AccountData account(String account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="rG1QQv2nh2gr7RCZ1P8YYcBUKCCN633jCn", value="")
    @JsonProperty(value="Account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public AccountData balance(String balance) {
        this.balance = balance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="999999999960", value="Balance in drops")
    @JsonProperty(value="Balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalance() {
        return this.balance;
    }

    public void setBalance(String balance) {
        this.balance = balance;
    }

    public AccountData flags(BigDecimal flags) {
        this.flags = flags;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8388608", value="")
    @JsonProperty(value="Flags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getFlags() {
        return this.flags;
    }

    public void setFlags(BigDecimal flags) {
        this.flags = flags;
    }

    public AccountData ledgerEntryType(String ledgerEntryType) {
        this.ledgerEntryType = ledgerEntryType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AccountRoot", value="")
    @JsonProperty(value="LedgerEntryType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLedgerEntryType() {
        return this.ledgerEntryType;
    }

    public void setLedgerEntryType(String ledgerEntryType) {
        this.ledgerEntryType = ledgerEntryType;
    }

    public AccountData ownerCount(BigDecimal ownerCount) {
        this.ownerCount = ownerCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="")
    @JsonProperty(value="OwnerCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getOwnerCount() {
        return this.ownerCount;
    }

    public void setOwnerCount(BigDecimal ownerCount) {
        this.ownerCount = ownerCount;
    }

    public AccountData previousTxnID(String previousTxnID) {
        this.previousTxnID = previousTxnID;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4294BEBE5B569A18C0A2702387C9B1E7146DC3A5850C1E87204951C6FDAA4C42", value="")
    @JsonProperty(value="PreviousTxnID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPreviousTxnID() {
        return this.previousTxnID;
    }

    public void setPreviousTxnID(String previousTxnID) {
        this.previousTxnID = previousTxnID;
    }

    public AccountData previousTxnLgrSeq(BigDecimal previousTxnLgrSeq) {
        this.previousTxnLgrSeq = previousTxnLgrSeq;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="")
    @JsonProperty(value="PreviousTxnLgrSeq")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getPreviousTxnLgrSeq() {
        return this.previousTxnLgrSeq;
    }

    public void setPreviousTxnLgrSeq(BigDecimal previousTxnLgrSeq) {
        this.previousTxnLgrSeq = previousTxnLgrSeq;
    }

    public AccountData sequence(BigDecimal sequence) {
        this.sequence = sequence;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6", value="")
    @JsonProperty(value="Sequence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getSequence() {
        return this.sequence;
    }

    public void setSequence(BigDecimal sequence) {
        this.sequence = sequence;
    }

    public AccountData index(String index) {
        this.index = index;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="92FA6A9FC8EA6018D5D16532D7795C91BFB0831355BDFDA177E86C8BF997985F", value="")
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountData accountData = (AccountData)o;
        return Objects.equals(this.account, accountData.account) && Objects.equals(this.balance, accountData.balance) && Objects.equals(this.flags, accountData.flags) && Objects.equals(this.ledgerEntryType, accountData.ledgerEntryType) && Objects.equals(this.ownerCount, accountData.ownerCount) && Objects.equals(this.previousTxnID, accountData.previousTxnID) && Objects.equals(this.previousTxnLgrSeq, accountData.previousTxnLgrSeq) && Objects.equals(this.sequence, accountData.sequence) && Objects.equals(this.index, accountData.index);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.balance, this.flags, this.ledgerEntryType, this.ownerCount, this.previousTxnID, this.previousTxnLgrSeq, this.sequence, this.index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountData {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    ledgerEntryType: ").append(this.toIndentedString(this.ledgerEntryType)).append("\n");
        sb.append("    ownerCount: ").append(this.toIndentedString(this.ownerCount)).append("\n");
        sb.append("    previousTxnID: ").append(this.toIndentedString(this.previousTxnID)).append("\n");
        sb.append("    previousTxnLgrSeq: ").append(this.toIndentedString(this.previousTxnLgrSeq)).append("\n");
        sb.append("    sequence: ").append(this.toIndentedString(this.sequence)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

