/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.rippled.api.client.model;

import app.keyconnect.rippled.api.client.model.AccountTransactionItem;
import app.keyconnect.rippled.api.client.model.AccountTransactionMarker;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"account", "ledger_index_max", "ledger_index_min", "limit", "marker", "status", "transactions", "validated"})
@JsonTypeName(value="AccountTransactionResult")
public class AccountTransactionResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCOUNT = "account";
    private String account;
    public static final String JSON_PROPERTY_LEDGER_INDEX_MAX = "ledger_index_max";
    private BigDecimal ledgerIndexMax;
    public static final String JSON_PROPERTY_LEDGER_INDEX_MIN = "ledger_index_min";
    private BigDecimal ledgerIndexMin;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private BigDecimal limit;
    public static final String JSON_PROPERTY_MARKER = "marker";
    private AccountTransactionMarker marker;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_TRANSACTIONS = "transactions";
    private List<AccountTransactionItem> transactions = null;
    public static final String JSON_PROPERTY_VALIDATED = "validated";
    private Boolean validated;

    public AccountTransactionResult account(String account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="rLNaPoKeeBjZe2qs6x52yVPZpZ8td4dc6w", value="")
    @JsonProperty(value="account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public AccountTransactionResult ledgerIndexMax(BigDecimal ledgerIndexMax) {
        this.ledgerIndexMax = ledgerIndexMax;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="57112019", value="")
    @JsonProperty(value="ledger_index_max")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getLedgerIndexMax() {
        return this.ledgerIndexMax;
    }

    public void setLedgerIndexMax(BigDecimal ledgerIndexMax) {
        this.ledgerIndexMax = ledgerIndexMax;
    }

    public AccountTransactionResult ledgerIndexMin(BigDecimal ledgerIndexMin) {
        this.ledgerIndexMin = ledgerIndexMin;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="56248229", value="")
    @JsonProperty(value="ledger_index_min")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getLedgerIndexMin() {
        return this.ledgerIndexMin;
    }

    public void setLedgerIndexMin(BigDecimal ledgerIndexMin) {
        this.ledgerIndexMin = ledgerIndexMin;
    }

    public AccountTransactionResult limit(BigDecimal limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="")
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getLimit() {
        return this.limit;
    }

    public void setLimit(BigDecimal limit) {
        this.limit = limit;
    }

    public AccountTransactionResult marker(AccountTransactionMarker marker) {
        this.marker = marker;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="marker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountTransactionMarker getMarker() {
        return this.marker;
    }

    public void setMarker(AccountTransactionMarker marker) {
        this.marker = marker;
    }

    public AccountTransactionResult status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="success", value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AccountTransactionResult transactions(List<AccountTransactionItem> transactions) {
        this.transactions = transactions;
        return this;
    }

    public AccountTransactionResult addTransactionsItem(AccountTransactionItem transactionsItem) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<AccountTransactionItem>();
        }
        this.transactions.add(transactionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="transactions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AccountTransactionItem> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<AccountTransactionItem> transactions) {
        this.transactions = transactions;
    }

    public AccountTransactionResult validated(Boolean validated) {
        this.validated = validated;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="")
    @JsonProperty(value="validated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidated() {
        return this.validated;
    }

    public void setValidated(Boolean validated) {
        this.validated = validated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountTransactionResult accountTransactionResult = (AccountTransactionResult)o;
        return Objects.equals(this.account, accountTransactionResult.account) && Objects.equals(this.ledgerIndexMax, accountTransactionResult.ledgerIndexMax) && Objects.equals(this.ledgerIndexMin, accountTransactionResult.ledgerIndexMin) && Objects.equals(this.limit, accountTransactionResult.limit) && Objects.equals(this.marker, accountTransactionResult.marker) && Objects.equals(this.status, accountTransactionResult.status) && Objects.equals(this.transactions, accountTransactionResult.transactions) && Objects.equals(this.validated, accountTransactionResult.validated);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.ledgerIndexMax, this.ledgerIndexMin, this.limit, this.marker, this.status, this.transactions, this.validated);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountTransactionResult {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    ledgerIndexMax: ").append(this.toIndentedString(this.ledgerIndexMax)).append("\n");
        sb.append("    ledgerIndexMin: ").append(this.toIndentedString(this.ledgerIndexMin)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    marker: ").append(this.toIndentedString(this.marker)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    validated: ").append(this.toIndentedString(this.validated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

