/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.rippled.api.client.model;

import app.keyconnect.rippled.api.client.model.AccountTransaction;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"tx_json", "engine_result", "engine_result_code", "engine_result_message", "tx_blob", "accepted", "account_sequence_available", "account_sequence_next", "applied", "broadcast", "kept", "queued", "open_ledger_cost", "validated_ledger_index"})
@JsonTypeName(value="SubmitTransactionResult")
public class SubmitTransactionResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_TX_JSON = "tx_json";
    private AccountTransaction txJson;
    public static final String JSON_PROPERTY_ENGINE_RESULT = "engine_result";
    private String engineResult;
    public static final String JSON_PROPERTY_ENGINE_RESULT_CODE = "engine_result_code";
    private Integer engineResultCode;
    public static final String JSON_PROPERTY_ENGINE_RESULT_MESSAGE = "engine_result_message";
    private String engineResultMessage;
    public static final String JSON_PROPERTY_TX_BLOB = "tx_blob";
    private String txBlob;
    public static final String JSON_PROPERTY_ACCEPTED = "accepted";
    private Boolean accepted;
    public static final String JSON_PROPERTY_ACCOUNT_SEQUENCE_AVAILABLE = "account_sequence_available";
    private BigDecimal accountSequenceAvailable;
    public static final String JSON_PROPERTY_ACCOUNT_SEQUENCE_NEXT = "account_sequence_next";
    private BigDecimal accountSequenceNext;
    public static final String JSON_PROPERTY_APPLIED = "applied";
    private Boolean applied;
    public static final String JSON_PROPERTY_BROADCAST = "broadcast";
    private Boolean broadcast;
    public static final String JSON_PROPERTY_KEPT = "kept";
    private Boolean kept;
    public static final String JSON_PROPERTY_QUEUED = "queued";
    private Boolean queued;
    public static final String JSON_PROPERTY_OPEN_LEDGER_COST = "open_ledger_cost";
    private String openLedgerCost;
    public static final String JSON_PROPERTY_VALIDATED_LEDGER_INDEX = "validated_ledger_index";
    private Integer validatedLedgerIndex;

    public SubmitTransactionResult txJson(AccountTransaction txJson) {
        this.txJson = txJson;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="tx_json")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountTransaction getTxJson() {
        return this.txJson;
    }

    public void setTxJson(AccountTransaction txJson) {
        this.txJson = txJson;
    }

    public SubmitTransactionResult engineResult(String engineResult) {
        this.engineResult = engineResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="tesSUCCESS", value="Text result code indicating the preliminary result of the transaction, for example tesSUCCESS")
    @JsonProperty(value="engine_result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEngineResult() {
        return this.engineResult;
    }

    public void setEngineResult(String engineResult) {
        this.engineResult = engineResult;
    }

    public SubmitTransactionResult engineResultCode(Integer engineResultCode) {
        this.engineResultCode = engineResultCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="Numeric version of the result code. Not recommended.")
    @JsonProperty(value="engine_result_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getEngineResultCode() {
        return this.engineResultCode;
    }

    public void setEngineResultCode(Integer engineResultCode) {
        this.engineResultCode = engineResultCode;
    }

    public SubmitTransactionResult engineResultMessage(String engineResultMessage) {
        this.engineResultMessage = engineResultMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="The transaction was applied. Only final in a validated ledger.", value="Human-readable explanation of the transaction's preliminary result")
    @JsonProperty(value="engine_result_message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEngineResultMessage() {
        return this.engineResultMessage;
    }

    public void setEngineResultMessage(String engineResultMessage) {
        this.engineResultMessage = engineResultMessage;
    }

    public SubmitTransactionResult txBlob(String txBlob) {
        this.txBlob = txBlob;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1200002280000000240000016961D4838D7EA4C6800000000000000000000000000055534400000000004B4E9C06F24296074F7BC48F92A97916C6DC5EA9684000000000002710732103AB40A0490F9B7ED8DF29D246BF2D6269820A0EE7742ACDD457BEA7C7D0931EDB74473045022100A7CCD11455E47547FF617D5BFC15D120D9053DFD0536B044F10CA3631CD609E502203B61DEE4AC027C5743A1B56AF568D1E2B8E79BB9E9E14744AC87F38375C3C2F181144B4E9C06F24296074F7BC48F92A97916C6DC5EA983143E9D4A2B8AA0780F682D136F7A56D6724EF53754", value="The complete transaction in hex string format")
    @JsonProperty(value="tx_blob")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTxBlob() {
        return this.txBlob;
    }

    public void setTxBlob(String txBlob) {
        this.txBlob = txBlob;
    }

    public SubmitTransactionResult accepted(Boolean accepted) {
        this.accepted = accepted;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="(Omitted in sign-and-submit mode) The value true indicates that the transaction was applied, queued, broadcast, or kept for later. The value false indicates that none of those happened, so the transaction cannot possibly succeed as long as you do not submit it again and have not already submitted it another time")
    @JsonProperty(value="accepted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAccepted() {
        return this.accepted;
    }

    public void setAccepted(Boolean accepted) {
        this.accepted = accepted;
    }

    public SubmitTransactionResult accountSequenceAvailable(BigDecimal accountSequenceAvailable) {
        this.accountSequenceAvailable = accountSequenceAvailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="362", value="(Omitted in sign-and-submit mode) The next Sequence Number available for the sending account after all pending and queued transactions. ")
    @JsonProperty(value="account_sequence_available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getAccountSequenceAvailable() {
        return this.accountSequenceAvailable;
    }

    public void setAccountSequenceAvailable(BigDecimal accountSequenceAvailable) {
        this.accountSequenceAvailable = accountSequenceAvailable;
    }

    public SubmitTransactionResult accountSequenceNext(BigDecimal accountSequenceNext) {
        this.accountSequenceNext = accountSequenceNext;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="362", value="(Omitted in sign-and-submit mode) The next Sequence Number for the sending account after all transactions that have been provisionally applied, but not transactions in the queue.")
    @JsonProperty(value="account_sequence_next")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getAccountSequenceNext() {
        return this.accountSequenceNext;
    }

    public void setAccountSequenceNext(BigDecimal accountSequenceNext) {
        this.accountSequenceNext = accountSequenceNext;
    }

    public SubmitTransactionResult applied(Boolean applied) {
        this.applied = applied;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="(Omitted in sign-and-submit mode) The value true indicates that this transaction was applied to the open ledger. In this case, the transaction is likely, but not guaranteed, to be validated in the next ledger version. ")
    @JsonProperty(value="applied")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getApplied() {
        return this.applied;
    }

    public void setApplied(Boolean applied) {
        this.applied = applied;
    }

    public SubmitTransactionResult broadcast(Boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="(Omitted in sign-and-submit mode) The value true indicates this transaction was broadcast to peer servers in the peer-to-peer XRP Ledger network. (Note: if the server has no peers, such as in stand-alone mode, the server uses the value true for cases where it would have broadcast the transaction.) The value false indicates the transaction was not broadcast to any other servers.")
    @JsonProperty(value="broadcast")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(Boolean broadcast) {
        this.broadcast = broadcast;
    }

    public SubmitTransactionResult kept(Boolean kept) {
        this.kept = kept;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="(Omitted in sign-and-submit mode) The value true indicates that the transaction was kept to be retried later.")
    @JsonProperty(value="kept")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getKept() {
        return this.kept;
    }

    public void setKept(Boolean kept) {
        this.kept = kept;
    }

    public SubmitTransactionResult queued(Boolean queued) {
        this.queued = queued;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="(Omitted in sign-and-submit mode) The value true indicates the transaction was put in the Transaction Queue, which means it is likely to be included in a future ledger version.")
    @JsonProperty(value="queued")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getQueued() {
        return this.queued;
    }

    public void setQueued(Boolean queued) {
        this.queued = queued;
    }

    public SubmitTransactionResult openLedgerCost(String openLedgerCost) {
        this.openLedgerCost = openLedgerCost;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="(Omitted in sign-and-submit mode) The current open ledger cost before processing this transaction. Transactions with a lower cost are likely to be queued.")
    @JsonProperty(value="open_ledger_cost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOpenLedgerCost() {
        return this.openLedgerCost;
    }

    public void setOpenLedgerCost(String openLedgerCost) {
        this.openLedgerCost = openLedgerCost;
    }

    public SubmitTransactionResult validatedLedgerIndex(Integer validatedLedgerIndex) {
        this.validatedLedgerIndex = validatedLedgerIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="21184416", value="(Omitted in sign-and-submit mode) The ledger index of the newest validated ledger at the time of submission. This provides a lower bound on the ledger versions that the transaction can appear in as a result of this request. (The transaction could only have been validated in this ledger version or earlier if it had already been submitted before.)")
    @JsonProperty(value="validated_ledger_index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getValidatedLedgerIndex() {
        return this.validatedLedgerIndex;
    }

    public void setValidatedLedgerIndex(Integer validatedLedgerIndex) {
        this.validatedLedgerIndex = validatedLedgerIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitTransactionResult submitTransactionResult = (SubmitTransactionResult)o;
        return Objects.equals(this.txJson, submitTransactionResult.txJson) && Objects.equals(this.engineResult, submitTransactionResult.engineResult) && Objects.equals(this.engineResultCode, submitTransactionResult.engineResultCode) && Objects.equals(this.engineResultMessage, submitTransactionResult.engineResultMessage) && Objects.equals(this.txBlob, submitTransactionResult.txBlob) && Objects.equals(this.accepted, submitTransactionResult.accepted) && Objects.equals(this.accountSequenceAvailable, submitTransactionResult.accountSequenceAvailable) && Objects.equals(this.accountSequenceNext, submitTransactionResult.accountSequenceNext) && Objects.equals(this.applied, submitTransactionResult.applied) && Objects.equals(this.broadcast, submitTransactionResult.broadcast) && Objects.equals(this.kept, submitTransactionResult.kept) && Objects.equals(this.queued, submitTransactionResult.queued) && Objects.equals(this.openLedgerCost, submitTransactionResult.openLedgerCost) && Objects.equals(this.validatedLedgerIndex, submitTransactionResult.validatedLedgerIndex);
    }

    public int hashCode() {
        return Objects.hash(this.txJson, this.engineResult, this.engineResultCode, this.engineResultMessage, this.txBlob, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubmitTransactionResult {\n");
        sb.append("    txJson: ").append(this.toIndentedString(this.txJson)).append("\n");
        sb.append("    engineResult: ").append(this.toIndentedString(this.engineResult)).append("\n");
        sb.append("    engineResultCode: ").append(this.toIndentedString(this.engineResultCode)).append("\n");
        sb.append("    engineResultMessage: ").append(this.toIndentedString(this.engineResultMessage)).append("\n");
        sb.append("    txBlob: ").append(this.toIndentedString(this.txBlob)).append("\n");
        sb.append("    accepted: ").append(this.toIndentedString(this.accepted)).append("\n");
        sb.append("    accountSequenceAvailable: ").append(this.toIndentedString(this.accountSequenceAvailable)).append("\n");
        sb.append("    accountSequenceNext: ").append(this.toIndentedString(this.accountSequenceNext)).append("\n");
        sb.append("    applied: ").append(this.toIndentedString(this.applied)).append("\n");
        sb.append("    broadcast: ").append(this.toIndentedString(this.broadcast)).append("\n");
        sb.append("    kept: ").append(this.toIndentedString(this.kept)).append("\n");
        sb.append("    queued: ").append(this.toIndentedString(this.queued)).append("\n");
        sb.append("    openLedgerCost: ").append(this.toIndentedString(this.openLedgerCost)).append("\n");
        sb.append("    validatedLedgerIndex: ").append(this.toIndentedString(this.validatedLedgerIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

