package app.valuationcontrol.multimodule.library.helpers.security;

import app.valuationcontrol.multimodule.library.helpers.exceptions.ResourceException;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.stereotype.Component;

@Component
public class JwtAuthenticationConverter implements Converter<Jwt, AbstractAuthenticationToken> {

  private final Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter =
      new JwtGrantedAuthoritiesConverter();

  @Autowired UserDetailsService userDetailsService;

  @Override
  public AbstractAuthenticationToken convert(@NonNull Jwt jwt) throws ResourceException {
    UserDetails currentUser;
    Collection<GrantedAuthority> authorities = this.jwtGrantedAuthoritiesConverter.convert(jwt);

    String emailClaimName = "preferred_username";
    String emailClaimValue = jwt.getClaimAsString(emailClaimName);
    try {
      currentUser = userDetailsService.loadUserByUsername(emailClaimValue);
    } catch (UsernameNotFoundException e) {
      currentUser = null;
    }

    return new UsernamePasswordAuthenticationToken(currentUser, null, authorities);
  }
}
