package app.valuationcontrol.multimodule.library.records;

import app.valuationcontrol.multimodule.library.helpers.PercentageFloatDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;

public record SensitivityData(
    Long id,
    @NotEmpty String name,
    @NotEmpty String description,
    @NotNull Long variable1Id,
    Long variable2Id,
    @NotNull Long measurementVariableId,
    Integer variable1Period,
    Integer variable2Period,
    @NotNull Integer measurementVariablePeriod,
    @NotNull Integer variable1Steps,
    Integer variable2Steps,
    @JsonDeserialize(using = PercentageFloatDeserializer.class) @NotNull Float variable1StepSize,
    @JsonDeserialize(using = PercentageFloatDeserializer.class) Float variable2StepSize,
    LocalDateTime lastRun) {}
