package app.valuationcontrol.multimodule.library.xlhandler;

import app.valuationcontrol.multimodule.library.helpers.stompInterceptors.TopicSubscriptionInterceptor;
import app.valuationcontrol.multimodule.library.records.CalculationData;
import java.util.HashSet;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.stereotype.Component;

@Component
@Log4j2
public class ModelChangeNotifier {
  private final SimpMessagingTemplate websocket;
  private final SimpUserRegistry userRegistry;

  @Autowired
  public ModelChangeNotifier(SimpMessagingTemplate websocket, SimpUserRegistry userRegistry) {
    this.websocket = websocket;
    this.userRegistry = userRegistry;
  }

  public HashSet<Integer> fetchScenariosFromUserRegistry(Long modelId) {
    HashSet<Integer> loadedScenarios = new HashSet<>();
    userRegistry
        .getUsers()
        .forEach(
            u ->
                u.getSessions()
                    .forEach(
                        simpSession ->
                            simpSession.getSubscriptions().stream()
                                .filter(
                                    simpSubscription ->
                                        simpSubscription
                                            .getDestination()
                                            .contains(
                                                TopicSubscriptionInterceptor.TOPIC_MODEL
                                                    + modelId
                                                    + "/"))
                                .forEach(
                                    simpSubscription -> {
                                      try {
                                        Integer scenarioNumber =
                                            Integer.parseInt(
                                                simpSubscription
                                                    .getDestination()
                                                    .replace(
                                                        TopicSubscriptionInterceptor.TOPIC_MODEL
                                                            + modelId
                                                            + "/",
                                                        ""));
                                        loadedScenarios.add(scenarioNumber);
                                      } catch (NumberFormatException e) {
                                        log.error("Couldn't parse scenarioNumber in subscription");
                                      }
                                    })));
    return loadedScenarios;
  }

  public HashSet<Integer> getLoadedScenario(long modelId) {

    HashSet<Integer> loadedScenarios = fetchScenariosFromUserRegistry(modelId);
    loadedScenarios.add(0);
    log.debug(loadedScenarios);
    return loadedScenarios;
  }

  public void updateUsersModel(CalculationData calculationData) {
    log.debug("Updating scenario: {}", calculationData.getScenarioNumber());
    websocket.convertAndSend(
        TopicSubscriptionInterceptor.TOPIC_MODEL
            + calculationData.getModel().id()
            + "/"
            + calculationData.getScenarioNumber(),
        calculationData);
  }
}
