/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.client.mina;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.message.interceptor.InterceptException;
import asia.stampy.common.mina.AbstractStampyMinaMessageGateway;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Resource;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Resource
@StampyLibrary(libraryName="stampy-MINA-client-server-RI")
public class ClientMinaMessageGateway
extends AbstractStampyMinaMessageGateway {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NioSocketConnector connector = new NioSocketConnector();
    private String host;

    private void init() {
        this.serviceAdapter.setGateway(this);
        this.serviceAdapter.setAutoShutdown(this.isAutoShutdown());
        log.trace("Initializing Stampy MINA connector");
        this.connector.setHandler((IoHandler)this.getHandler());
        this.connector.addListener((IoServiceListener)this.serviceAdapter);
        DefaultIoFilterChainBuilder chain = this.connector.getFilterChain();
        MdcInjectionFilter mdcInjectionFilter = new MdcInjectionFilter();
        chain.addLast("mdc", (IoFilter)mdcInjectionFilter);
        chain.addLast("codec", (IoFilter)new ProtocolCodecFilter(this.getHandler().getFactory(this.getMaxMessageSize())));
        log.trace("Connector initialized");
    }

    public void connect() throws Exception {
        log.trace("connect() invoked");
        if (this.connector != null && this.connector.isActive()) {
            log.warn("connect invoked when already connected");
            return;
        }
        if (this.connector == null || this.connector.isDisposed()) {
            this.connector = new NioSocketConnector();
            this.addServiceListeners();
        }
        if (!this.connector.isActive()) {
            this.init();
        }
        ConnectFuture cf = this.connector.connect((SocketAddress)new InetSocketAddress(this.getHost(), this.getPort()));
        cf.await(2000L);
        if (this.connector.isActive()) {
            log.info("Stampy MINA ClientMinaMessageGateway connected to {}:{}", (Object)this.host, (Object)this.getPort());
        } else {
            log.error("Could not connect to {}:{}", (Object)this.host, (Object)this.getPort());
        }
    }

    private void addServiceListeners() {
        for (IoServiceListener l : this.getServiceListeners()) {
            this.connector.addListener(l);
        }
    }

    public boolean isConnected(HostPort hostPort) {
        return this.serviceAdapter.hasSession(hostPort) && this.connector.isActive();
    }

    public void closeConnection(HostPort hostPort) {
        this.serviceAdapter.closeAllSessions();
        this.connector.dispose();
    }

    public void shutdown() throws Exception {
        this.closeConnection(null);
    }

    public void sendMessage(String message, HostPort hostPort) throws InterceptException {
        this.broadcastMessage(message);
    }

    public void broadcastMessage(String message) throws InterceptException {
        if (!this.connector.isActive()) {
            log.warn("Attempting to send message {} when the connector is not active", (Object)message);
            throw new IllegalStateException("The connector is not active, cannot send message");
        }
        this.interceptOutgoingMessage(message);
        for (HostPort hostPort : this.serviceAdapter.getHostPorts()) {
            this.getHandler().getHeartbeatContainer().reset(hostPort);
        }
        this.connector.broadcast((Object)message);
    }

    protected void addServiceListenerImpl(IoServiceListener listener) {
        this.connector.addListener(listener);
    }

    protected void removeServiceListenerImpl(IoServiceListener listener) {
        this.connector.removeListener(listener);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

