/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.mina;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.DefaultUnparseableMessageHandler;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.MessageListenerHaltException;
import asia.stampy.common.gateway.StampyHandlerHelper;
import asia.stampy.common.gateway.UnparseableMessageHandler;
import asia.stampy.common.heartbeat.StampyHeartbeatContainer;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.parsing.StompMessageParser;
import asia.stampy.common.parsing.UnparseableException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.prefixedstring.PrefixedStringCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StampyLibrary(libraryName="stampy-MINA-client-server-RI")
public abstract class StampyMinaHandler
extends IoHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private StompMessageParser parser = new StompMessageParser();
    private StampyHeartbeatContainer heartbeatContainer;
    private AbstractStampyMessageGateway gateway;
    private static final String ILLEGAL_ACCESS_ATTEMPT = "Illegal access attempt";
    private Executor executor = Executors.newSingleThreadExecutor();
    public static Charset CHARSET = Charset.forName("UTF-8");
    private UnparseableMessageHandler unparseableMessageHandler = new DefaultUnparseableMessageHandler();
    protected StampyHandlerHelper helper = new StampyHandlerHelper();

    public void messageReceived(IoSession session, Object message) throws Exception {
        final HostPort hostPort = new HostPort((InetSocketAddress)session.getRemoteAddress());
        log.debug("Received raw message {} from {}", message, (Object)hostPort);
        this.helper.resetHeartbeat(hostPort);
        if (!this.helper.isValidObject(message)) {
            log.error("Object {} is not a valid STOMP message, closing connection {}", message, (Object)hostPort);
            this.illegalAccess(session);
            return;
        }
        final String msg = (String)message;
        if (this.helper.isHeartbeat(msg)) {
            log.trace("Received heartbeat");
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                StampyMinaHandler.this.asyncProcessing(hostPort, msg);
            }
        };
        this.getExecutor().execute(runnable);
    }

    public ProtocolCodecFactory getFactory(int maxMessageSize) {
        PrefixedStringCodecFactory factory = new PrefixedStringCodecFactory(CHARSET);
        factory.setDecoderMaxDataLength(maxMessageSize);
        factory.setEncoderMaxDataLength(maxMessageSize);
        return factory;
    }

    protected void asyncProcessing(HostPort hostPort, String msg) {
        StampyMessage sm = null;
        try {
            sm = this.getParser().parseMessage(msg);
            this.getGateway().notifyMessageListeners(sm, hostPort);
        }
        catch (UnparseableException e) {
            this.helper.handleUnparseableMessage(hostPort, msg, e);
        }
        catch (MessageListenerHaltException e) {
        }
        catch (Exception e) {
            this.helper.handleUnexpectedError(hostPort, msg, sm, e);
        }
    }

    protected void illegalAccess(IoSession session) {
        session.write((Object)ILLEGAL_ACCESS_ATTEMPT);
        session.close(false);
    }

    public StompMessageParser getParser() {
        return this.parser;
    }

    public void setParser(StompMessageParser parser) {
        this.parser = parser;
        this.helper.setParser(parser);
    }

    public StampyHeartbeatContainer getHeartbeatContainer() {
        return this.heartbeatContainer;
    }

    public void setHeartbeatContainer(StampyHeartbeatContainer heartbeatContainer) {
        this.heartbeatContainer = heartbeatContainer;
        this.helper.setHeartbeatContainer(heartbeatContainer);
    }

    public AbstractStampyMessageGateway getGateway() {
        return this.gateway;
    }

    public void setGateway(AbstractStampyMessageGateway gateway) {
        this.gateway = gateway;
        this.helper.setGateway(gateway);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public UnparseableMessageHandler getUnparseableMessageHandler() {
        return this.unparseableMessageHandler;
    }

    public void setUnparseableMessageHandler(UnparseableMessageHandler unparseableMessageHandler) {
        this.unparseableMessageHandler = unparseableMessageHandler;
        this.helper.setUnparseableMessageHandler(unparseableMessageHandler);
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        HostPort hostPort = new HostPort((InetSocketAddress)session.getRemoteAddress());
        log.error("Unexpected exception for " + hostPort, cause);
    }
}

