/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.mina;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.mina.AbstractStampyMinaMessageGateway;
import asia.stampy.common.mina.MinaServiceAdapter;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Resource
@StampyLibrary(libraryName="stampy-MINA-client-server-RI")
public class StampyServiceAdapter
extends MinaServiceAdapter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<HostPort, IoSession> sessions = new ConcurrentHashMap<HostPort, IoSession>();
    private boolean autoShutdown;
    private AbstractStampyMinaMessageGateway gateway;

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        HostPort hostPort = this.createHostPort(session);
        log.info("Stampy MINA session created for {}", (Object)hostPort);
        this.sessions.put(hostPort, session);
    }

    @Override
    public void sessionDestroyed(IoSession session) throws Exception {
        HostPort hostPort = this.createHostPort(session);
        log.info("Stampy MINA session destroyed for {}", (Object)hostPort);
        this.sessions.remove(hostPort);
        if (this.sessions.isEmpty() && this.isAutoShutdown()) {
            log.info("No more sessions and auto shutdown is true, shutting down gateway");
            this.gateway.shutdown();
        }
    }

    public void closeAllSessions() {
        for (IoSession session : this.sessions.values()) {
            CloseFuture cf = session.close(true);
            cf.awaitUninterruptibly();
        }
        this.sessions.clear();
    }

    public void closeSession(HostPort hostPort) {
        IoSession session = this.sessions.get(hostPort);
        if (session != null) {
            session.close(false);
        }
    }

    private HostPort createHostPort(IoSession session) {
        return new HostPort((InetSocketAddress)session.getRemoteAddress());
    }

    public boolean hasSession(HostPort hostPort) {
        return this.sessions.containsKey(hostPort);
    }

    public IoSession getSession(HostPort hostPort) {
        IoSession session = this.sessions.get(hostPort);
        if (session == null) {
            throw new IllegalArgumentException(hostPort.toString() + " has no current session");
        }
        return session;
    }

    public Set<HostPort> getHostPorts() {
        return Collections.unmodifiableSet(this.sessions.keySet());
    }

    public void sendMessage(String stompMessage, HostPort hostPort) {
        if (!this.hasSession(hostPort)) {
            log.error("No session for {}, cannot send message {}", (Object)hostPort, (Object)stompMessage);
            return;
        }
        IoSession session = this.getSession(hostPort);
        if (session.isConnected() && !session.isClosing()) {
            session.write((Object)stompMessage);
            log.trace("Sent message {} to {}", (Object)stompMessage, (Object)hostPort);
        } else {
            log.error("Session is not active for {}, cannot send message {}", (Object)hostPort, (Object)stompMessage);
        }
    }

    public boolean isAutoShutdown() {
        return this.autoShutdown;
    }

    public void setAutoShutdown(boolean autoClose) {
        this.autoShutdown = autoClose;
    }

    public AbstractStampyMinaMessageGateway getGateway() {
        return this.gateway;
    }

    public void setGateway(AbstractStampyMinaMessageGateway gateway) {
        this.gateway = gateway;
    }
}

