/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.mina.raw;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.MessageListenerHaltException;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.common.mina.StampyMinaHandler;
import asia.stampy.common.mina.raw.StringCodecFactory;
import asia.stampy.common.parsing.UnparseableException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StampyLibrary(libraryName="stampy-MINA-client-server-RI")
public abstract class StampyRawStringHandler
extends StampyMinaHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<HostPort, String> messageParts = new ConcurrentHashMap<HostPort, String>();

    public void messageReceived(IoSession session, Object message) throws Exception {
        final HostPort hostPort = new HostPort((InetSocketAddress)session.getRemoteAddress());
        log.trace("Received raw message {} from {}", message, (Object)hostPort);
        this.helper.resetHeartbeat(hostPort);
        if (!this.helper.isValidObject(message)) {
            log.error("Object {} is not a valid STOMP message, closing connection {}", message, (Object)hostPort);
            this.illegalAccess(session);
            return;
        }
        final String msg = (String)message;
        Runnable runnable = new Runnable(){

            public void run() {
                StampyRawStringHandler.this.asyncProcessing(hostPort, msg);
            }
        };
        this.getExecutor().execute(runnable);
    }

    public ProtocolCodecFactory getFactory(int maxMessageSize) {
        return new StringCodecFactory(maxMessageSize);
    }

    protected void asyncProcessing(HostPort hostPort, String msg) {
        try {
            String existing = this.messageParts.get(hostPort);
            if (StringUtils.isEmpty((String)existing)) {
                this.processNewMessage(hostPort, msg);
            } else {
                String concat = existing + msg;
                this.processMessage(concat, hostPort);
            }
        }
        catch (UnparseableException e) {
            this.helper.handleUnparseableMessage(hostPort, msg, e);
        }
        catch (MessageListenerHaltException e) {
        }
        catch (Exception e) {
            this.helper.handleUnexpectedError(hostPort, msg, null, e);
        }
    }

    private void processNewMessage(HostPort hostPort, String msg) throws Exception, UnparseableException, IOException {
        if (this.helper.isHeartbeat(msg)) {
            log.trace("Received heartbeat");
            return;
        }
        if (this.isStompMessage(msg)) {
            this.processMessage(msg, hostPort);
        } else {
            this.helper.handleUnparseableMessage(hostPort, msg, null);
        }
    }

    private void processMessage(String msg, HostPort hostPort) throws Exception {
        int length = msg.length();
        int idx = msg.indexOf("\u0000");
        if (idx == length - 1) {
            log.trace("Creating StampyMessage from {}", (Object)msg);
            this.processStompMessage(msg, hostPort);
        } else if (idx > 0) {
            log.trace("Multiple messages detected, parsing {}", (Object)msg);
            this.processMultiMessages(msg, hostPort);
        } else {
            this.messageParts.put(hostPort, msg);
            log.trace("Message part {} stored for {}", (Object)msg, (Object)hostPort);
        }
    }

    private void processMultiMessages(String msg, HostPort hostPort) throws Exception {
        int idx = msg.indexOf("\u0000");
        String fullMessage = msg.substring(0, idx + 1);
        String partMessage = msg.substring(idx);
        if (partMessage.startsWith("\u0000")) {
            partMessage = partMessage.substring(1);
        }
        this.processStompMessage(fullMessage, hostPort);
        this.processMessage(partMessage, hostPort);
    }

    private void processStompMessage(String msg, HostPort hostPort) throws MessageListenerHaltException {
        this.messageParts.remove(hostPort);
        StampyMessage sm = null;
        try {
            sm = this.getParser().parseMessage(msg);
            this.getGateway().notifyMessageListeners(sm, hostPort);
        }
        catch (MessageListenerHaltException e) {
            throw e;
        }
        catch (Exception e) {
            this.helper.handleUnexpectedError(hostPort, msg, sm, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStompMessage(String msg) throws Exception {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(msg));
            String stompMessageType = reader.readLine();
            StompMessageType type = StompMessageType.valueOf((String)stompMessageType);
            boolean bl = type != null;
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

