/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.mina.raw;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.mina.StampyMinaHandler;
import java.io.InputStream;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

@StampyLibrary(libraryName="stampy-MINA-client-server-RI")
public class StringDecoder
extends CumulativeProtocolDecoder {
    private int maxDataLength = Integer.MAX_VALUE;

    public StringDecoder(int maxDataLength) {
        this.setMaxDataLength(maxDataLength);
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (!in.hasRemaining()) {
            return false;
        }
        InputStream is = in.asInputStream();
        int available = is.available();
        if (available > this.getMaxDataLength()) {
            throw new IllegalArgumentException("Data length: " + available);
        }
        byte[] b = new byte[available];
        is.read(b);
        String decoded = new String(b, StampyMinaHandler.CHARSET).replace("\nnull", "\n");
        out.write((Object)decoded);
        return true;
    }

    public int getMaxDataLength() {
        return this.maxDataLength;
    }

    public void setMaxDataLength(int maxDataLength) {
        this.maxDataLength = maxDataLength;
    }
}

