/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.mina.raw;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.mina.StampyMinaHandler;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

@StampyLibrary(libraryName="stampy-MINA-client-server-RI")
public class StringEncoder
extends ProtocolEncoderAdapter {
    private int maxDataLength = Integer.MAX_VALUE;

    public StringEncoder(int maxDataLength) {
        this.setMaxDataLength(maxDataLength);
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        String value = (String)message;
        IoBuffer buf = IoBuffer.allocate((int)value.length()).setAutoExpand(true);
        buf.putString((CharSequence)value, StampyMinaHandler.CHARSET.newEncoder());
        if (buf.position() > this.getMaxDataLength()) {
            throw new IllegalArgumentException("Data length: " + buf.position());
        }
        buf.flip();
        out.write((Object)buf);
    }

    public int getMaxDataLength() {
        return this.maxDataLength;
    }

    public void setMaxDataLength(int maxDataLength) {
        this.maxDataLength = maxDataLength;
    }
}

