/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.mina;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.message.interceptor.InterceptException;
import asia.stampy.common.mina.AbstractStampyMinaMessageGateway;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Resource;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Resource
@StampyLibrary(libraryName="stampy-MINA-client-server-RI")
public class ServerMinaMessageGateway
extends AbstractStampyMinaMessageGateway {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NioSocketAcceptor acceptor = new NioSocketAcceptor();

    private void init() {
        log.trace("Initializing Stampy MINA acceptor");
        this.serviceAdapter.setGateway(this);
        this.serviceAdapter.setAutoShutdown(this.isAutoShutdown());
        this.acceptor.setReuseAddress(true);
        this.acceptor.setCloseOnDeactivation(true);
        this.acceptor.setHandler((IoHandler)this.getHandler());
        this.acceptor.addListener((IoServiceListener)this.serviceAdapter);
        DefaultIoFilterChainBuilder chain = this.acceptor.getFilterChain();
        MdcInjectionFilter mdcInjectionFilter = new MdcInjectionFilter();
        chain.addLast("mdc", (IoFilter)mdcInjectionFilter);
        chain.addLast("codec", (IoFilter)new ProtocolCodecFilter(this.getHandler().getFactory(this.getMaxMessageSize())));
        log.trace("Acceptor initialized");
    }

    public void connect() throws Exception {
        log.trace("connect() invoked");
        if (this.acceptor != null && this.acceptor.isActive()) {
            log.warn("connect invoked when already connected");
            return;
        }
        if (this.acceptor == null || this.acceptor.isDisposed()) {
            this.acceptor = new NioSocketAcceptor();
            this.addServiceListeners();
        }
        if (!this.acceptor.isActive()) {
            this.init();
        }
        this.acceptor.bind((SocketAddress)new InetSocketAddress(this.getPort()));
        log.info("connect() invoked, bound to port {}", (Object)this.getPort());
    }

    private void addServiceListeners() {
        for (IoServiceListener l : this.getServiceListeners()) {
            this.acceptor.addListener(l);
        }
    }

    public boolean isConnected(HostPort hostPort) {
        return this.serviceAdapter.hasSession(hostPort) && this.acceptor.isActive();
    }

    public void sendMessage(String message, HostPort hostPort) throws InterceptException {
        if (!this.isConnected(hostPort)) {
            log.warn("Attempting to send message {} to {} when the acceptor is not active", (Object)message, (Object)hostPort);
            throw new IllegalStateException("The acceptor is not active, cannot send message");
        }
        this.interceptOutgoingMessage(message);
        this.getHandler().getHeartbeatContainer().reset(hostPort);
        this.serviceAdapter.sendMessage(message, hostPort);
    }

    public void broadcastMessage(String message) throws InterceptException {
        if (!this.acceptor.isActive()) {
            log.warn("Attempting to broadcast {} when the acceptor is not active", (Object)message);
            throw new IllegalStateException("The acceptor is not active, cannot send message");
        }
        this.interceptOutgoingMessage(message);
        for (HostPort hostPort : this.serviceAdapter.getHostPorts()) {
            this.getHandler().getHeartbeatContainer().reset(hostPort);
        }
        this.acceptor.broadcast((Object)message);
    }

    public void closeConnection(HostPort hostPort) {
        if (!this.serviceAdapter.hasSession(hostPort)) {
            return;
        }
        log.info("closeConnection() invoked, closing session for {}", (Object)hostPort);
        IoSession session = this.serviceAdapter.getSession(hostPort);
        CloseFuture cf = session.close(false);
        cf.awaitUninterruptibly();
    }

    public void shutdown() throws Exception {
        log.info("shutdown() invoked, disposing the acceptor");
        this.serviceAdapter.closeAllSessions();
        this.acceptor.dispose(false);
    }

    protected void addServiceListenerImpl(IoServiceListener listener) {
        this.acceptor.addListener(listener);
    }

    protected void removeServiceListenerImpl(IoServiceListener listener) {
        this.acceptor.removeListener(listener);
    }
}

