/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.attestation;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lat/asitplus/attestation/AttestationObject;", "", "fmt", "", "attStmt", "Lat/asitplus/attestation/AttestationObject$AttestationStatement;", "authData", "", "(Ljava/lang/String;Lat/asitplus/attestation/AttestationObject$AttestationStatement;[B)V", "getAttStmt", "()Lat/asitplus/attestation/AttestationObject$AttestationStatement;", "getAuthData", "()[B", "getFmt", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "AttestationStatement", "attestation-service"})
public final class AttestationObject {
    @NotNull
    private final String fmt;
    @NotNull
    private final AttestationStatement attStmt;
    @NotNull
    private final byte[] authData;

    public AttestationObject(@NotNull String fmt, @NotNull AttestationStatement attStmt, @NotNull byte[] authData) {
        Intrinsics.checkNotNullParameter((Object)fmt, (String)"fmt");
        Intrinsics.checkNotNullParameter((Object)attStmt, (String)"attStmt");
        Intrinsics.checkNotNullParameter((Object)authData, (String)"authData");
        this.fmt = fmt;
        this.attStmt = attStmt;
        this.authData = authData;
    }

    @NotNull
    public final String getFmt() {
        return this.fmt;
    }

    @NotNull
    public final AttestationStatement getAttStmt() {
        return this.attStmt;
    }

    @NotNull
    public final byte[] getAuthData() {
        return this.authData;
    }

    @NotNull
    public final String component1() {
        return this.fmt;
    }

    @NotNull
    public final AttestationStatement component2() {
        return this.attStmt;
    }

    @NotNull
    public final byte[] component3() {
        return this.authData;
    }

    @NotNull
    public final AttestationObject copy(@NotNull String fmt, @NotNull AttestationStatement attStmt, @NotNull byte[] authData) {
        Intrinsics.checkNotNullParameter((Object)fmt, (String)"fmt");
        Intrinsics.checkNotNullParameter((Object)attStmt, (String)"attStmt");
        Intrinsics.checkNotNullParameter((Object)authData, (String)"authData");
        return new AttestationObject(fmt, attStmt, authData);
    }

    public static /* synthetic */ AttestationObject copy$default(AttestationObject attestationObject, String string, AttestationStatement attestationStatement, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            string = attestationObject.fmt;
        }
        if ((n & 2) != 0) {
            attestationStatement = attestationObject.attStmt;
        }
        if ((n & 4) != 0) {
            byArray = attestationObject.authData;
        }
        return attestationObject.copy(string, attestationStatement, byArray);
    }

    @NotNull
    public String toString() {
        return "AttestationObject(fmt=" + this.fmt + ", attStmt=" + this.attStmt + ", authData=" + Arrays.toString(this.authData) + ")";
    }

    public int hashCode() {
        int result = this.fmt.hashCode();
        result = result * 31 + this.attStmt.hashCode();
        result = result * 31 + Arrays.hashCode(this.authData);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttestationObject)) {
            return false;
        }
        AttestationObject attestationObject = (AttestationObject)other;
        if (!Intrinsics.areEqual((Object)this.fmt, (Object)attestationObject.fmt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.attStmt, (Object)attestationObject.attStmt)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.authData, (Object)attestationObject.authData);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lat/asitplus/attestation/AttestationObject$AttestationStatement;", "", "x5c", "", "", "receipt", "(Ljava/util/List;[B)V", "getReceipt", "()[B", "getX5c", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "attestation-service"})
    public static final class AttestationStatement {
        @NotNull
        private final List<byte[]> x5c;
        @NotNull
        private final byte[] receipt;

        public AttestationStatement(@NotNull List<byte[]> x5c, @NotNull byte[] receipt) {
            Intrinsics.checkNotNullParameter(x5c, (String)"x5c");
            Intrinsics.checkNotNullParameter((Object)receipt, (String)"receipt");
            this.x5c = x5c;
            this.receipt = receipt;
        }

        @NotNull
        public final List<byte[]> getX5c() {
            return this.x5c;
        }

        @NotNull
        public final byte[] getReceipt() {
            return this.receipt;
        }

        @NotNull
        public final List<byte[]> component1() {
            return this.x5c;
        }

        @NotNull
        public final byte[] component2() {
            return this.receipt;
        }

        @NotNull
        public final AttestationStatement copy(@NotNull List<byte[]> x5c, @NotNull byte[] receipt) {
            Intrinsics.checkNotNullParameter(x5c, (String)"x5c");
            Intrinsics.checkNotNullParameter((Object)receipt, (String)"receipt");
            return new AttestationStatement(x5c, receipt);
        }

        public static /* synthetic */ AttestationStatement copy$default(AttestationStatement attestationStatement, List list, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                list = attestationStatement.x5c;
            }
            if ((n & 2) != 0) {
                byArray = attestationStatement.receipt;
            }
            return attestationStatement.copy(list, byArray);
        }

        @NotNull
        public String toString() {
            return "AttestationStatement(x5c=" + this.x5c + ", receipt=" + Arrays.toString(this.receipt) + ")";
        }

        public int hashCode() {
            int result = ((Object)this.x5c).hashCode();
            result = result * 31 + Arrays.hashCode(this.receipt);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AttestationStatement)) {
                return false;
            }
            AttestationStatement attestationStatement = (AttestationStatement)other;
            if (!Intrinsics.areEqual(this.x5c, attestationStatement.x5c)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.receipt, (Object)attestationStatement.receipt);
        }
    }
}

