/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.attestation;

import at.asitplus.attestation.AttestationException;
import at.asitplus.attestation.AttestationResult;
import at.asitplus.attestation.ExtensionsKt;
import ch.veehait.devicecheck.appattest.assertion.Assertion;
import ch.veehait.devicecheck.appattest.attestation.ValidatedAttestation;
import com.google.android.attestation.AttestationApplicationId;
import com.google.android.attestation.ParsedAttestationRecord;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lat/asitplus/attestation/AttestationResult;", "", "()V", "details", "", "getDetails", "()Ljava/lang/String;", "toString", "Android", "Error", "IOS", "Lat/asitplus/attestation/AttestationResult$Android;", "Lat/asitplus/attestation/AttestationResult$Error;", "Lat/asitplus/attestation/AttestationResult$IOS;", "attestation-service"})
public abstract class AttestationResult {
    private AttestationResult() {
    }

    @NotNull
    public String toString() {
        return "AttestationResult::" + this.getDetails() + ")";
    }

    @NotNull
    protected abstract String getDetails();

    public /* synthetic */ AttestationResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00078TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000e\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u001a"}, d2={"Lat/asitplus/attestation/AttestationResult$Android;", "Lat/asitplus/attestation/AttestationResult;", "attestationCertificateChain", "", "Ljava/security/cert/X509Certificate;", "(Ljava/util/List;)V", "androidDetails", "", "getAndroidDetails", "()Ljava/lang/String;", "attestationCertificate", "getAttestationCertificate", "()Ljava/security/cert/X509Certificate;", "attestationCertificate$delegate", "Lkotlin/Lazy;", "getAttestationCertificateChain", "()Ljava/util/List;", "attestationRecord", "Lcom/google/android/attestation/ParsedAttestationRecord;", "getAttestationRecord", "()Lcom/google/android/attestation/ParsedAttestationRecord;", "details", "getDetails", "details$delegate", "NOOP", "Verified", "attestation-service"})
    public static abstract class Android
    extends AttestationResult {
        @NotNull
        private final List<X509Certificate> attestationCertificateChain;
        @NotNull
        private final Lazy details$delegate;
        @NotNull
        private final Lazy attestationCertificate$delegate;

        public Android(@NotNull List<? extends X509Certificate> attestationCertificateChain) {
            Intrinsics.checkNotNullParameter(attestationCertificateChain, (String)"attestationCertificateChain");
            super(null);
            this.attestationCertificateChain = attestationCertificateChain;
            this.details$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ Android this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Android::" + this.this$0.getAndroidDetails();
                }
            }));
            this.attestationCertificate$delegate = LazyKt.lazy((Function0)((Function0)new Function0<X509Certificate>(this){
                final /* synthetic */ Android this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final X509Certificate invoke() {
                    return (X509Certificate)CollectionsKt.first(this.this$0.getAttestationCertificateChain());
                }
            }));
        }

        @NotNull
        public final List<X509Certificate> getAttestationCertificateChain() {
            return this.attestationCertificateChain;
        }

        @NotNull
        protected abstract String getAndroidDetails();

        @Override
        @NotNull
        protected String getDetails() {
            Lazy lazy = this.details$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public abstract ParsedAttestationRecord getAttestationRecord();

        @NotNull
        public final X509Certificate getAttestationCertificate() {
            Lazy lazy = this.attestationCertificate$delegate;
            return (X509Certificate)lazy.getValue();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lat/asitplus/attestation/AttestationResult$Android$NOOP;", "Lat/asitplus/attestation/AttestationResult$Android;", "attestationCertificateChain", "", "", "(Ljava/util/List;)V", "androidDetails", "", "getAndroidDetails", "()Ljava/lang/String;", "attestationRecord", "Lcom/google/android/attestation/ParsedAttestationRecord;", "getAttestationRecord", "()Lcom/google/android/attestation/ParsedAttestationRecord;", "attestationRecord$delegate", "Lkotlin/Lazy;", "attestation-service"})
        @SourceDebugExtension(value={"SMAP\nAttestationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/AttestationResult$Android$NOOP\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,772:1\n1603#2,9:773\n1855#2:782\n1856#2:784\n1612#2:785\n1#3:783\n*S KotlinDebug\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/AttestationResult$Android$NOOP\n*L\n296#1:773,9\n296#1:782\n296#1:784\n296#1:785\n296#1:783\n*E\n"})
        public static final class NOOP
        extends Android {
            @NotNull
            private final String androidDetails;
            @NotNull
            private final Lazy attestationRecord$delegate;

            /*
             * WARNING - void declaration
             */
            public NOOP(@NotNull List<byte[]> attestationCertificateChain) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter(attestationCertificateChain, (String)"attestationCertificateChain");
                Iterable iterable = attestationCertificateChain;
                NOOP nOOP = this;
                boolean $i$f$mapNotNull = false;
                void var4_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    X509Certificate it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    byte[] it = (byte[])element$iv$iv;
                    boolean bl2 = false;
                    if (ExtensionsKt.parseToCertificate(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                super((List)destination$iv$iv);
                this.androidDetails = "NOOP";
                this.attestationRecord$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ParsedAttestationRecord>(attestationCertificateChain){
                    final /* synthetic */ List<byte[]> $attestationCertificateChain;
                    {
                        this.$attestationCertificateChain = $attestationCertificateChain;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final ParsedAttestationRecord invoke() {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = this.$attestationCertificateChain;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            X509Certificate it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            byte[] it = (byte[])element$iv$iv;
                            boolean bl2 = false;
                            if (ExtensionsKt.parseToCertificate(it) == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        return ParsedAttestationRecord.createParsedAttestationRecord((List)((List)destination$iv$iv));
                    }
                }));
            }

            @Override
            @NotNull
            protected String getAndroidDetails() {
                return this.androidDetails;
            }

            @Override
            @NotNull
            public ParsedAttestationRecord getAttestationRecord() {
                Lazy lazy = this.attestationRecord$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                return (ParsedAttestationRecord)object;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lat/asitplus/attestation/AttestationResult$Android$Verified;", "Lat/asitplus/attestation/AttestationResult$Android;", "attestationCertificateChain", "", "Ljava/security/cert/X509Certificate;", "(Ljava/util/List;)V", "androidDetails", "", "getAndroidDetails", "()Ljava/lang/String;", "attestationRecord", "Lcom/google/android/attestation/ParsedAttestationRecord;", "getAttestationRecord", "()Lcom/google/android/attestation/ParsedAttestationRecord;", "attestation-service"})
        public static final class Verified
        extends Android {
            @NotNull
            private final ParsedAttestationRecord attestationRecord;
            @NotNull
            private final String androidDetails;

            /*
             * WARNING - void declaration
             */
            public Verified(@NotNull List<? extends X509Certificate> attestationCertificateChain) {
                String string;
                Intrinsics.checkNotNullParameter(attestationCertificateChain, (String)"attestationCertificateChain");
                super(attestationCertificateChain);
                ParsedAttestationRecord parsedAttestationRecord = ParsedAttestationRecord.createParsedAttestationRecord(attestationCertificateChain);
                Intrinsics.checkNotNullExpressionValue((Object)parsedAttestationRecord, (String)"createParsedAttestationRecord(...)");
                this.attestationRecord = parsedAttestationRecord;
                Verified verified = this;
                String string2 = this.getAttestationRecord().keymasterSecurityLevel.name();
                String string3 = this.getAttestationRecord().attestationSecurityLevel.name();
                String string4 = this.getAttestationRecord().attestedKey.getAlgorithm();
                byte[] byArray = this.getAttestationRecord().attestedKey.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
                String string5 = ExtensionsKt.encodeBase64(byArray);
                Optional optional = this.getAttestationRecord().softwareEnforced.attestationApplicationId;
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"attestationApplicationId");
                AttestationApplicationId attestationApplicationId = (AttestationApplicationId)OptionalsKt.getOrNull((Optional)optional);
                if (attestationApplicationId != null) {
                    void app;
                    AttestationApplicationId attestationApplicationId2 = attestationApplicationId;
                    String string6 = string5;
                    String string7 = string4;
                    String string8 = string3;
                    String string9 = string2;
                    Verified verified2 = verified;
                    boolean bl = false;
                    List list = app.packageInfos;
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageInfos");
                    String string10 = ", packageInfos: " + CollectionsKt.joinToString$default((Iterable)list, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)androidDetails.1.1.INSTANCE, (int)25, null);
                    verified = verified2;
                    string2 = string9;
                    string3 = string8;
                    string4 = string7;
                    string5 = string6;
                    string = string10;
                } else {
                    string = null;
                }
                verified.androidDetails = "Verified(keyMaster security level: " + string2 + ", attestation security level: " + string3 + ", " + string4 + " public key: " + string5 + string;
            }

            @Override
            @NotNull
            public ParsedAttestationRecord getAttestationRecord() {
                return this.attestationRecord;
            }

            @Override
            @NotNull
            protected String getAndroidDetails() {
                return this.androidDetails;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lat/asitplus/attestation/AttestationResult$Error;", "Lat/asitplus/attestation/AttestationResult;", "explanation", "", "cause", "Lat/asitplus/attestation/AttestationException;", "(Ljava/lang/String;Lat/asitplus/attestation/AttestationException;)V", "getCause", "()Lat/asitplus/attestation/AttestationException;", "details", "getDetails", "()Ljava/lang/String;", "getExplanation", "attestation-service"})
    @SourceDebugExtension(value={"SMAP\nAttestationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/AttestationResult$Error\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,772:1\n1#2:773\n*E\n"})
    public static final class Error
    extends AttestationResult {
        @NotNull
        private final String explanation;
        @Nullable
        private final AttestationException cause;
        @NotNull
        private final String details;

        public Error(@NotNull String explanation, @Nullable AttestationException cause) {
            String string;
            Intrinsics.checkNotNullParameter((Object)explanation, (String)"explanation");
            super(null);
            this.explanation = explanation;
            this.cause = cause;
            Error error = this;
            String string2 = this.explanation;
            AttestationException attestationException = this.cause;
            if (attestationException != null) {
                AttestationException attestationException2 = attestationException;
                String string3 = string2;
                Error error2 = error;
                boolean bl = false;
                String string4 = ", Cause: " + Reflection.getOrCreateKotlinClass(this.cause.getClass()).getQualifiedName();
                error = error2;
                string2 = string3;
                string = string4;
            } else {
                string = null;
            }
            error.details = "Error(" + string2 + string;
        }

        public /* synthetic */ Error(String string, AttestationException attestationException, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                attestationException = null;
            }
            this(string, attestationException);
        }

        @NotNull
        public final String getExplanation() {
            return this.explanation;
        }

        @Nullable
        public final AttestationException getCause() {
            return this.cause;
        }

        @Override
        @NotNull
        protected String getDetails() {
            return this.details;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0012\u0010\r\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0011"}, d2={"Lat/asitplus/attestation/AttestationResult$IOS;", "Lat/asitplus/attestation/AttestationResult;", "clientData", "", "([B)V", "getClientData", "()[B", "details", "", "getDetails", "()Ljava/lang/String;", "details$delegate", "Lkotlin/Lazy;", "iosDetails", "getIosDetails", "NOOP", "Verified", "attestation-service"})
    public static abstract class IOS
    extends AttestationResult {
        @Nullable
        private final byte[] clientData;
        @NotNull
        private final Lazy details$delegate;

        public IOS(@Nullable byte[] clientData) {
            super(null);
            this.clientData = clientData;
            this.details$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ IOS this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "iOS::" + this.this$0.getIosDetails();
                }
            }));
        }

        @Nullable
        public final byte[] getClientData() {
            return this.clientData;
        }

        @NotNull
        public abstract String getIosDetails();

        @Override
        @NotNull
        protected String getDetails() {
            Lazy lazy = this.details$delegate;
            return (String)lazy.getValue();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/asitplus/attestation/AttestationResult$IOS$NOOP;", "Lat/asitplus/attestation/AttestationResult$IOS;", "clientData", "", "([B)V", "iosDetails", "", "getIosDetails", "()Ljava/lang/String;", "attestation-service"})
        public static final class NOOP
        extends IOS {
            @NotNull
            private final String iosDetails;

            public NOOP(@Nullable byte[] clientData) {
                super(clientData);
                this.iosDetails = "NOOP";
            }

            @Override
            @NotNull
            public String getIosDetails() {
                return this.iosDetails;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lat/asitplus/attestation/AttestationResult$IOS$Verified;", "Lat/asitplus/attestation/AttestationResult$IOS;", "attestation", "Lch/veehait/devicecheck/appattest/attestation/ValidatedAttestation;", "assertedClientData", "Lkotlin/Pair;", "", "Lch/veehait/devicecheck/appattest/assertion/Assertion;", "(Lch/veehait/devicecheck/appattest/attestation/ValidatedAttestation;Lkotlin/Pair;)V", "getAttestation", "()Lch/veehait/devicecheck/appattest/attestation/ValidatedAttestation;", "iosDetails", "", "getIosDetails", "()Ljava/lang/String;", "attestation-service"})
        public static final class Verified
        extends IOS {
            @NotNull
            private final ValidatedAttestation attestation;
            @NotNull
            private final String iosDetails;

            public Verified(@NotNull ValidatedAttestation attestation, @Nullable Pair<byte[], Assertion> assertedClientData) {
                Intrinsics.checkNotNullParameter((Object)attestation, (String)"attestation");
                Pair<byte[], Assertion> pair = assertedClientData;
                super((byte[])(pair != null ? (byte[])pair.getFirst() : null));
                this.attestation = attestation;
                String string = this.attestation.getCertificate().getPublicKey().getAlgorithm();
                byte[] byArray = this.attestation.getCertificate().getPublicKey().getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
                this.iosDetails = "Verified(" + string + " public key: " + ExtensionsKt.encodeBase64(byArray) + ", iOS version: " + this.attestation.getIOSVersion() + ", app: " + this.attestation.getReceipt().getPayload().getAppId();
            }

            @NotNull
            public final ValidatedAttestation getAttestation() {
                return this.attestation;
            }

            @Override
            @NotNull
            public String getIosDetails() {
                return this.iosDetails;
            }
        }
    }
}

