/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.attestation;

import at.asitplus.attestation.AttestationException;
import at.asitplus.attestation.AttestationResult;
import at.asitplus.attestation.ExtensionsKt;
import at.asitplus.attestation.KeyAttestation;
import at.asitplus.attestation.Platform;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000fH \u00a2\u0006\u0002\b\u0012J9\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u0019J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lat/asitplus/attestation/AttestationService;", "", "()V", "android", "Lat/asitplus/attestation/AttestationService$Android;", "getAndroid", "()Lat/asitplus/attestation/AttestationService$Android;", "ios", "Lat/asitplus/attestation/AttestationService$IOS;", "getIos", "()Lat/asitplus/attestation/AttestationService$IOS;", "verifyAttestation", "Lat/asitplus/attestation/AttestationResult;", "attestationProof", "", "", "challenge", "clientData", "verifyAttestation$attestation_service", "verifyKeyAttestation", "Lat/asitplus/attestation/KeyAttestation;", "T", "Ljava/security/PublicKey;", "expectedChallenge", "keyToBeAttested", "(Ljava/util/List;[BLjava/security/PublicKey;)Lat/asitplus/attestation/KeyAttestation;", "encodedPublicKey", "Android", "IOS", "attestation-service"})
@SourceDebugExtension(value={"SMAP\nAttestationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/AttestationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,772:1\n1#2:773\n*E\n"})
public abstract class AttestationService {
    @NotNull
    public abstract AttestationResult verifyAttestation$attestation_service(@NotNull List<byte[]> var1, @NotNull byte[] var2, @Nullable byte[] var3);

    public static /* synthetic */ AttestationResult verifyAttestation$attestation_service$default(AttestationService attestationService, List list, byte[] byArray, byte[] byArray2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: verifyAttestation");
        }
        if ((n & 4) != 0) {
            byArray2 = null;
        }
        return attestationService.verifyAttestation$attestation_service(list, byArray, byArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final <T extends PublicKey> KeyAttestation<T> verifyKeyAttestation(@NotNull List<byte[]> attestationProof, @NotNull byte[] expectedChallenge, @NotNull T keyToBeAttested) {
        KeyAttestation<Object> keyAttestation;
        Intrinsics.checkNotNullParameter(attestationProof, (String)"attestationProof");
        Intrinsics.checkNotNullParameter((Object)expectedChallenge, (String)"expectedChallenge");
        Intrinsics.checkNotNullParameter(keyToBeAttested, (String)"keyToBeAttested");
        AttestationResult firstTry = this.verifyAttestation$attestation_service(attestationProof, expectedChallenge, keyToBeAttested.getEncoded());
        if (firstTry instanceof AttestationResult.Android) {
            if (Arrays.equals(keyToBeAttested.getEncoded(), ((AttestationResult.Android)firstTry).getAttestationCertificate().getPublicKey().getEncoded())) {
                keyAttestation = new KeyAttestation<T>(keyToBeAttested, firstTry);
                return keyAttestation;
            } else {
                byte[] byArray = keyToBeAttested.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
                String string = ExtensionsKt.encodeBase64(byArray);
                byte[] byArray2 = ((AttestationResult.Android)firstTry).getAttestationCertificate().getPublicKey().getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
                String it = "Android attestation failed: keyToBeAttested (" + string + ") does not match key from attestation certificate: " + ExtensionsKt.encodeBase64(byArray2);
                boolean bl = false;
                keyAttestation = new KeyAttestation<Object>(null, new AttestationResult.Error(it, new AttestationException.Content(Platform.ANDROID, it, null, 4, null)));
            }
            return keyAttestation;
        }
        if (firstTry instanceof AttestationResult.Error) {
            Object object;
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)this.verifyAttestation$attestation_service(attestationProof, expectedChallenge, ExtensionsKt.toAnsi((ECPublicKey)keyToBeAttested)));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it = throwable;
                return new KeyAttestation<Object>(null, firstTry);
            }
            AttestationResult secondTry = (AttestationResult)object;
            if (secondTry instanceof AttestationResult.Android) {
                throw new RuntimeException("WTF?");
            }
            if (secondTry instanceof AttestationResult.Error) {
                keyAttestation = new KeyAttestation<Object>(null, firstTry);
                return keyAttestation;
            } else {
                if (!(secondTry instanceof AttestationResult.IOS)) throw new NoWhenBranchMatchedException();
                keyAttestation = new KeyAttestation<T>(keyToBeAttested, secondTry);
            }
            return keyAttestation;
        }
        if (!(firstTry instanceof AttestationResult.IOS)) throw new NoWhenBranchMatchedException();
        keyAttestation = new KeyAttestation<Object>(keyToBeAttested, firstTry);
        return keyAttestation;
    }

    @NotNull
    public final KeyAttestation<PublicKey> verifyKeyAttestation(@NotNull List<byte[]> attestationProof, @NotNull byte[] challenge, @NotNull byte[] encodedPublicKey) {
        Intrinsics.checkNotNullParameter(attestationProof, (String)"attestationProof");
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        Intrinsics.checkNotNullParameter((Object)encodedPublicKey, (String)"encodedPublicKey");
        return this.verifyKeyAttestation(attestationProof, challenge, ExtensionsKt.parseToPublicKey(encodedPublicKey));
    }

    @NotNull
    public abstract IOS getIos();

    @NotNull
    public abstract Android getAndroid();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lat/asitplus/attestation/AttestationService$Android;", "", "verifyKeyAttestation", "Lat/asitplus/attestation/KeyAttestation;", "Ljava/security/PublicKey;", "attestationCerts", "", "Ljava/security/cert/X509Certificate;", "expectedChallenge", "", "attestation-service"})
    public static interface Android {
        @NotNull
        public KeyAttestation<PublicKey> verifyKeyAttestation(@NotNull List<? extends X509Certificate> var1, @NotNull byte[] var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J2\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lat/asitplus/attestation/AttestationService$IOS;", "", "verifyAppAttestation", "Lat/asitplus/attestation/AttestationResult;", "attestationObject", "", "challenge", "verifyAssertion", "assertionFromDevice", "referenceClientData", "counter", "", "attestation-service"})
    public static interface IOS {
        @NotNull
        public AttestationResult verifyAppAttestation(@NotNull byte[] var1, @NotNull byte[] var2);

        @NotNull
        public AttestationResult verifyAssertion(@NotNull byte[] var1, @NotNull byte[] var2, @NotNull byte[] var3, @NotNull byte[] var4, long var5);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ AttestationResult verifyAssertion$default(IOS iOS, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, long l, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: verifyAssertion");
                }
                if ((n & 0x10) != 0) {
                    l = 0L;
                }
                return iOS.verifyAssertion(byArray, byArray2, byArray3, byArray4, l);
            }
        }
    }
}

