/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.attestation;

import at.asitplus.attestation.AssertionData;
import at.asitplus.attestation.AttestationException;
import at.asitplus.attestation.AttestationObject;
import at.asitplus.attestation.AttestationResult;
import at.asitplus.attestation.AttestationService;
import at.asitplus.attestation.DefaultAttestationService;
import at.asitplus.attestation.ExtensionsKt;
import at.asitplus.attestation.IOSAttestationConfiguration;
import at.asitplus.attestation.KeyAttestation;
import at.asitplus.attestation.Platform;
import at.asitplus.attestation.android.AndroidAttestationChecker;
import at.asitplus.attestation.android.AndroidAttestationConfiguration;
import at.asitplus.attestation.android.HardwareAttestationChecker;
import at.asitplus.attestation.android.NougatHybridAttestationChecker;
import at.asitplus.attestation.android.SoftwareAttestationChecker;
import at.asitplus.attestation.android.exceptions.CertificateInvalidException;
import ch.veehait.devicecheck.appattest.AppleAppAttest;
import ch.veehait.devicecheck.appattest.assertion.Assertion;
import ch.veehait.devicecheck.appattest.assertion.AssertionChallengeValidator;
import ch.veehait.devicecheck.appattest.assertion.AssertionValidator;
import ch.veehait.devicecheck.appattest.attestation.AttestationException;
import ch.veehait.devicecheck.appattest.attestation.AttestationValidator;
import ch.veehait.devicecheck.appattest.attestation.ValidatedAttestation;
import ch.veehait.devicecheck.appattest.common.App;
import ch.veehait.devicecheck.appattest.common.AppleAppAttestEnvironment;
import ch.veehait.devicecheck.appattest.receipt.ReceiptException;
import ch.veehait.devicecheck.appattest.receipt.ReceiptValidator;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import net.swiftzer.semver.SemVer;
import org.bouncycastle.cert.X509CertificateHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB,\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J-\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u0002022\b\u00104\u001a\u0004\u0018\u000102H\u0010\u00a2\u0006\u0002\b5J\u001e\u00106\u001a\u00020/2\f\u00107\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00108\u001a\u000202H\u0002J7\u00109\u001a\u00020/2\u0006\u0010:\u001a\u0002022\u0006\u00108\u001a\u0002022\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020>H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010@R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n \u001a*\u0004\u0018\u00010(0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010)\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006A"}, d2={"Lat/asitplus/attestation/DefaultAttestationService;", "Lat/asitplus/attestation/AttestationService;", "androidAttestationConfigurationJ", "Lat/asitplus/attestation/android/AndroidAttestationConfiguration;", "iosAttestationConfigurationJ", "Lat/asitplus/attestation/IOSAttestationConfiguration;", "verificationTimeOffsetJ", "Ljava/time/Duration;", "javaClock", "Ljava/time/Clock;", "(Lat/asitplus/attestation/android/AndroidAttestationConfiguration;Lat/asitplus/attestation/IOSAttestationConfiguration;Ljava/time/Duration;Ljava/time/Clock;)V", "androidAttestationConfiguration", "iosAttestationConfiguration", "clock", "Lkotlinx/datetime/Clock;", "verificationTimeOffset", "Lkotlin/time/Duration;", "(Lat/asitplus/attestation/android/AndroidAttestationConfiguration;Lat/asitplus/attestation/IOSAttestationConfiguration;Lkotlinx/datetime/Clock;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "android", "Lat/asitplus/attestation/AttestationService$Android;", "getAndroid", "()Lat/asitplus/attestation/AttestationService$Android;", "androidAttestationCheckers", "", "Lat/asitplus/attestation/android/AndroidAttestationChecker;", "appAttestClock", "kotlin.jvm.PlatformType", "appAttestReader", "Lcom/fasterxml/jackson/databind/ObjectReader;", "attestationValidators", "", "Lch/veehait/devicecheck/appattest/AppleAppAttest;", "Lch/veehait/devicecheck/appattest/attestation/AttestationValidator;", "ios", "Lat/asitplus/attestation/AttestationService$IOS;", "getIos", "()Lat/asitplus/attestation/AttestationService$IOS;", "iosApps", "Lat/asitplus/attestation/IOSAttestationConfiguration$AppData;", "log", "Lorg/slf4j/Logger;", "J", "encapsulateIosAttestationException", "Lat/asitplus/attestation/AttestationException;", "it", "", "verifyAttestation", "Lat/asitplus/attestation/AttestationResult;", "attestationProof", "", "", "challenge", "clientData", "verifyAttestation$attestation_service", "verifyAttestationAndroid", "attestationCerts", "expectedChallenge", "verifyAttestationApple", "attestationObject", "assertionData", "Lat/asitplus/attestation/AssertionData;", "counter", "", "verifyAttestationApple-t-mv6J0", "([B[BLkotlin/Pair;J)Lat/asitplus/attestation/AttestationResult;", "attestation-service"})
@SourceDebugExtension(value={"SMAP\nAttestationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/DefaultAttestationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,772:1\n1271#2,2:773\n1285#2,4:775\n1271#2,2:779\n1285#2,4:781\n1549#2:786\n1620#2,3:787\n1603#2,9:790\n1855#2:799\n1856#2:801\n1612#2:802\n1549#2:803\n1620#2,3:804\n766#2:807\n857#2,2:808\n288#2,2:810\n766#2:816\n857#2,2:817\n223#2,2:819\n288#2,2:821\n1#3:785\n1#3:800\n125#4:812\n152#4,3:813\n*S KotlinDebug\n*F\n+ 1 AttestationService.kt\nat/asitplus/attestation/DefaultAttestationService\n*L\n482#1:773,2\n482#1:775,4\n499#1:779,2\n499#1:781,4\n559#1:786\n559#1:787,3\n590#1:790,9\n590#1:799\n590#1:801\n590#1:802\n595#1:803\n595#1:804,3\n604#1:807\n604#1:808,2\n606#1:810,2\n679#1:816\n679#1:817,2\n683#1:819,2\n687#1:821,2\n590#1:800\n667#1:812\n667#1:813,3\n*E\n"})
public final class DefaultAttestationService
extends AttestationService {
    @NotNull
    private final IOSAttestationConfiguration iosAttestationConfiguration;
    @NotNull
    private final Clock clock;
    private final long verificationTimeOffset;
    private final Logger log;
    @NotNull
    private final List<AndroidAttestationChecker> androidAttestationCheckers;
    @NotNull
    private final Map<IOSAttestationConfiguration.AppData, AppleAppAttest> iosApps;
    private final ObjectReader appAttestReader;
    private final java.time.Clock appAttestClock;
    @NotNull
    private final Map<AppleAppAttest, AttestationValidator> attestationValidators;
    @NotNull
    private final AttestationService.IOS ios;
    @NotNull
    private final AttestationService.Android android;

    /*
     * WARNING - void declaration
     */
    private DefaultAttestationService(AndroidAttestationConfiguration androidAttestationConfiguration, IOSAttestationConfiguration iosAttestationConfiguration, Clock clock, long verificationTimeOffset) {
        AppleAppAttest appleAppAttest;
        AppleAppAttest appData;
        Map map;
        Object t;
        void $this$associateWith$iv322;
        void $this$androidAttestationCheckers_u24lambda_u240;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)androidAttestationConfiguration, (String)"androidAttestationConfiguration");
        Intrinsics.checkNotNullParameter((Object)iosAttestationConfiguration, (String)"iosAttestationConfiguration");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.iosAttestationConfiguration = iosAttestationConfiguration;
        this.clock = clock;
        this.verificationTimeOffset = verificationTimeOffset;
        this.log = LoggerFactory.getLogger(this.getClass());
        List list = iterable = (List)new ArrayList();
        DefaultAttestationService defaultAttestationService = this;
        boolean bl = false;
        if (!androidAttestationConfiguration.getDisableHardwareAttestation()) {
            $this$androidAttestationCheckers_u24lambda_u240.add(new HardwareAttestationChecker(androidAttestationConfiguration, (Function2)androidAttestationCheckers.1.1.INSTANCE));
        }
        if (androidAttestationConfiguration.getEnableNougatAttestation()) {
            $this$androidAttestationCheckers_u24lambda_u240.add(new NougatHybridAttestationChecker(androidAttestationConfiguration, (Function2)androidAttestationCheckers.1.2.INSTANCE));
        }
        if (androidAttestationConfiguration.getEnableSoftwareAttestation()) {
            $this$androidAttestationCheckers_u24lambda_u240.add(new SoftwareAttestationChecker(androidAttestationConfiguration, (Function2)androidAttestationCheckers.1.3.INSTANCE));
        }
        defaultAttestationService.androidAttestationCheckers = iterable;
        iterable = this.iosAttestationConfiguration.getApplications();
        defaultAttestationService = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv22 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv322, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv22 = $this$associateWith$iv322;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv22) {
            IOSAttestationConfiguration.AppData appData2 = (IOSAttestationConfiguration.AppData)element$iv$iv;
            t = element$iv$iv;
            map = result$iv22;
            boolean bl2 = false;
            appleAppAttest = new AppleAppAttest(new App(appData.getTeamIdentifier(), appData.getBundleIdentifier()), appData.getSandbox() ? AppleAppAttestEnvironment.DEVELOPMENT : AppleAppAttestEnvironment.PRODUCTION);
            map.put(t, appleAppAttest);
        }
        defaultAttestationService.iosApps = result$iv22;
        this.appAttestReader = com.fasterxml.jackson.module.kotlin.ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper((JsonFactory)new CBORFactory())).readerFor(AttestationObject.class);
        java.time.Clock clock2 = ExtensionsKt.toJavaClock(this.clock);
        long $this$associateWith$iv322 = this.verificationTimeOffset;
        int result$iv22 = Duration.getNanosecondsComponent-impl((long)$this$associateWith$iv322);
        long $this$associateWithTo$iv$iv22 = Duration.getInWholeSeconds-impl((long)$this$associateWith$iv322);
        java.time.Duration duration = java.time.Duration.ofSeconds($this$associateWithTo$iv$iv22, result$iv22);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toJavaDuration-LRDsOJo");
        this.appAttestClock = java.time.Clock.offset(clock2, duration);
        Iterable $this$associateWith$iv322 = this.iosApps.values();
        defaultAttestationService = this;
        $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv322, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv322;
        $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void app;
            appData = (AppleAppAttest)element$iv$iv;
            t = element$iv$iv;
            map = result$iv;
            boolean bl3 = false;
            java.time.Clock clock3 = this.appAttestClock;
            Intrinsics.checkNotNullExpressionValue((Object)clock3, (String)"appAttestClock");
            java.time.Clock clock4 = this.appAttestClock;
            Intrinsics.checkNotNullExpressionValue((Object)clock4, (String)"appAttestClock");
            long l = Duration.times-UwyO8pc((long)Duration.getAbsoluteValue-UwyO8pc((long)this.verificationTimeOffset), (int)2);
            int n = Duration.getNanosecondsComponent-impl((long)l);
            long l2 = Duration.getInWholeSeconds-impl((long)l);
            java.time.Duration duration2 = java.time.Duration.ofSeconds(l2, n);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toJavaDuration-LRDsOJo");
            java.time.Duration duration3 = duration2.plus(ReceiptValidator.APPLE_RECOMMENDED_MAX_AGE);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"plus(...)");
            appleAppAttest = AppleAppAttest.createAttestationValidator$default((AppleAppAttest)app, null, (java.time.Clock)clock3, (ReceiptValidator)AppleAppAttest.createReceiptValidator$default((AppleAppAttest)app, null, (java.time.Clock)clock4, (java.time.Duration)duration3, (int)1, null), (int)1, null);
            map.put(t, appleAppAttest);
        }
        defaultAttestationService.attestationValidators = result$iv;
        this.ios = new AttestationService.IOS(this){
            final /* synthetic */ DefaultAttestationService this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public AttestationResult verifyAppAttestation(@NotNull byte[] attestationObject, @NotNull byte[] challenge) {
                Intrinsics.checkNotNullParameter((Object)attestationObject, (String)"attestationObject");
                Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
                return DefaultAttestationService.access$verifyAttestationApple-t-mv6J0(this.this$0, attestationObject, challenge, null, 0L);
            }

            @NotNull
            public AttestationResult verifyAssertion(@NotNull byte[] attestationObject, @NotNull byte[] assertionFromDevice, @NotNull byte[] referenceClientData, @NotNull byte[] challenge, long counter) {
                Intrinsics.checkNotNullParameter((Object)attestationObject, (String)"attestationObject");
                Intrinsics.checkNotNullParameter((Object)assertionFromDevice, (String)"assertionFromDevice");
                Intrinsics.checkNotNullParameter((Object)referenceClientData, (String)"referenceClientData");
                Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
                return DefaultAttestationService.access$verifyAttestationApple-t-mv6J0(this.this$0, attestationObject, challenge, AssertionData.constructor-impl(assertionFromDevice, referenceClientData), counter);
            }
        };
        this.android = new AttestationService.Android(this){
            final /* synthetic */ DefaultAttestationService this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public KeyAttestation<PublicKey> verifyKeyAttestation(@NotNull List<? extends X509Certificate> attestationCerts, @NotNull byte[] expectedChallenge) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(attestationCerts, (String)"attestationCerts");
                Intrinsics.checkNotNullParameter((Object)expectedChallenge, (String)"expectedChallenge");
                Iterable iterable = attestationCerts;
                DefaultAttestationService defaultAttestationService = this.this$0;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getEncoded());
                }
                PublicKey publicKey = ((X509Certificate)CollectionsKt.first(attestationCerts)).getPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublicKey(...)");
                return defaultAttestationService.verifyKeyAttestation((List<byte[]>)((List)destination$iv$iv), expectedChallenge, publicKey);
            }
        };
    }

    public /* synthetic */ DefaultAttestationService(AndroidAttestationConfiguration androidAttestationConfiguration, IOSAttestationConfiguration iOSAttestationConfiguration, Clock clock, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        if ((n & 8) != 0) {
            l = Duration.Companion.getZERO-UwyO8pc();
        }
        this(androidAttestationConfiguration, iOSAttestationConfiguration, clock, l, null);
    }

    @JvmOverloads
    public DefaultAttestationService(@NotNull AndroidAttestationConfiguration androidAttestationConfigurationJ, @NotNull IOSAttestationConfiguration iosAttestationConfigurationJ, @NotNull java.time.Duration verificationTimeOffsetJ, @NotNull java.time.Clock javaClock) {
        Intrinsics.checkNotNullParameter((Object)androidAttestationConfigurationJ, (String)"androidAttestationConfigurationJ");
        Intrinsics.checkNotNullParameter((Object)iosAttestationConfigurationJ, (String)"iosAttestationConfigurationJ");
        Intrinsics.checkNotNullParameter((Object)verificationTimeOffsetJ, (String)"verificationTimeOffsetJ");
        Intrinsics.checkNotNullParameter((Object)javaClock, (String)"javaClock");
        java.time.Duration duration = verificationTimeOffsetJ;
        this(androidAttestationConfigurationJ, iosAttestationConfigurationJ, ExtensionsKt.toKotlinClock(javaClock), Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)), null);
    }

    public /* synthetic */ DefaultAttestationService(AndroidAttestationConfiguration androidAttestationConfiguration, IOSAttestationConfiguration iOSAttestationConfiguration, java.time.Duration duration, java.time.Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            java.time.Duration duration2 = java.time.Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            duration = duration2;
        }
        if ((n & 8) != 0) {
            java.time.Clock clock2 = java.time.Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(androidAttestationConfiguration, iOSAttestationConfiguration, duration, clock);
    }

    @Override
    @NotNull
    public AttestationService.IOS getIos() {
        return this.ios;
    }

    @Override
    @NotNull
    public AttestationService.Android getAndroid() {
        return this.android;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AttestationResult verifyAttestation$attestation_service(@NotNull List<byte[]> attestationProof, @NotNull byte[] challenge, @Nullable byte[] clientData) {
        AttestationResult attestationResult;
        Intrinsics.checkNotNullParameter(attestationProof, (String)"attestationProof");
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        this.log.debug("attestation proof length: " + attestationProof.size());
        if (attestationProof.isEmpty()) {
            attestationResult = new AttestationResult.Error("Attestation proof is empty", null, 2, null);
        } else if (attestationProof.size() > 2) {
            attestationResult = this.verifyAttestationAndroid(attestationProof, challenge);
        } else {
            Object object;
            Object object2;
            Object object3;
            try {
                Pair<? extends byte[], ? extends byte[]> pair;
                boolean bl = false;
                Object object4 = this;
                byte[] byArray = (byte[])CollectionsKt.first(attestationProof);
                byte[] byArray2 = challenge;
                if (clientData != null) {
                    Throwable it;
                    byte[] byArray3 = clientData;
                    byte[] byArray4 = byArray2;
                    object3 = byArray;
                    object2 = object4;
                    boolean bl2 = false;
                    Pair<? extends byte[], ? extends byte[]> pair2 = AssertionData.constructor-impl(attestationProof.get(1), (byte[])it);
                    object4 = object2;
                    byArray = object3;
                    byArray2 = byArray4;
                    pair = pair2;
                } else {
                    pair = null;
                }
                object = Result.constructor-impl((Object)((DefaultAttestationService)object4).verifyAttestationApple-t-mv6J0(byArray, byArray2, pair, 0L));
            }
            catch (Throwable it) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                AttestationResult attestationResult2;
                Object object5;
                String $this$mapTo$iv$iv;
                void $this$map$iv;
                it = throwable;
                boolean bl = false;
                object3 = attestationProof;
                object2 = "Could not verify attestation proof: {}";
                Logger logger = this.log;
                boolean $i$f$map = false;
                void var11_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator.next();
                    byte[] byArray = (byte[])item$iv$iv;
                    object5 = destination$iv$iv;
                    boolean bl3 = false;
                    object5.add(ExtensionsKt.encodeBase64((byte[])it));
                }
                object5 = (List)destination$iv$iv;
                logger.warn((String)object2, object5);
                if (it instanceof IndexOutOfBoundsException) {
                    attestationResult2 = new AttestationResult.Error("Invalid length of attestation proof: " + it.getMessage() + ". Possible reason: passed 'clientData' but no assertion", null, 2, null);
                } else {
                    String string;
                    Object object6 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                    String string2 = it.getMessage();
                    if (string2 != null) {
                        void it;
                        $this$mapTo$iv$iv = string2;
                        object5 = object6;
                        boolean bl4 = false;
                        string = ". " + (String)it;
                        object6 = object5;
                    } else {
                        string = null;
                    }
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    AttestationException attestationException = null;
                    String string3 = "Could not verify client integrity due to internal error: " + (String)object6 + string;
                    attestationResult2 = new AttestationResult.Error(string3, attestationException, n, defaultConstructorMarker);
                }
                return attestationResult2;
            }
            attestationResult = (AttestationResult)object;
        }
        return attestationResult;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final AttestationResult verifyAttestationAndroid(List<byte[]> attestationCerts, byte[] expectedChallenge) {
        var3_3 = this;
        try {
            block17: {
                block16: {
                    $this$verifyAttestationAndroid_u24lambda_u2414 = var3_3;
                    $i$a$-runCatching-DefaultAttestationService$verifyAttestationAndroid$1 = false;
                    $this$verifyAttestationAndroid_u24lambda_u2414.log.debug("Verifying Android attestation");
                    if (attestationCerts.isEmpty()) {
                        return new AttestationResult.Error("Attestation proof is empty", null, 2, null);
                    }
                    $this$mapNotNull$iv = attestationCerts;
                    $i$f$mapNotNull = false;
                    var8_10 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var13_23 = $this$forEach$iv$iv$iv.iterator();
                    while (var13_23.hasNext()) {
                        element$iv$iv = element$iv$iv$iv /* !! */  = var13_23.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (byte[])element$iv$iv;
                        $i$a$-mapNotNull-DefaultAttestationService$verifyAttestationAndroid$1$certificates$1 = false;
                        if (ExtensionsKt.parseToCertificate(it) == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    certificates = (List)destination$iv$iv;
                    if (certificates.size() != attestationCerts.size()) {
                        return new AttestationResult.Error("Could not parse Android attestation certificate chain", null, 2, null);
                    }
                    $this$map$iv = $this$verifyAttestationAndroid_u24lambda_u2414.androidAttestationCheckers;
                    $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        element$iv$iv$iv /* !! */  = (AndroidAttestationChecker)item$iv$iv;
                        var22_38 = destination$iv$iv;
                        $i$a$-map-DefaultAttestationService$verifyAttestationAndroid$1$results$1 = false;
                        var16_30 = $this$verifyAttestationAndroid_u24lambda_u2414;
                        try {
                            $this$verifyAttestationAndroid_u24lambda_u2414_u24lambda_u2410_u24lambda_u249 = var16_30;
                            $i$a$-runCatching-DefaultAttestationService$verifyAttestationAndroid$1$results$1$1 = false;
                            v0 = ExtensionsKt.toJavaDate($this$verifyAttestationAndroid_u24lambda_u2414_u24lambda_u2410_u24lambda_u249.clock.now().plus-LRDsOJo($this$verifyAttestationAndroid_u24lambda_u2414_u24lambda_u2410_u24lambda_u249.verificationTimeOffset));
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toJavaDate(...)");
                            var17_31 = Result.constructor-impl((Object)it.verifyAttestation(certificates, v0, expectedChallenge));
                        }
                        catch (Throwable var18_34) {
                            var17_31 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var18_34));
                        }
                        var22_38.add(Result.box-impl((Object)var17_31));
                    }
                    results = (List)destination$iv$iv;
                    $this$filter$iv = results;
                    $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = ((Result)element$iv$iv).unbox-impl();
                        $i$a$-filter-DefaultAttestationService$verifyAttestationAndroid$1$1 = false;
                        if (!Result.isFailure-impl((Object)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    if (((List)destination$iv$iv).size() != $this$verifyAttestationAndroid_u24lambda_u2414.androidAttestationCheckers.size()) break block17;
                    $this$firstOrNull$iv = results;
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = ((Result)element$iv).unbox-impl();
                        $i$a$-firstOrNull-DefaultAttestationService$verifyAttestationAndroid$1$2 = false;
                        if (!(Result.exceptionOrNull-impl((Object)it) instanceof CertificateInvalidException)) ** GOTO lbl-1000
                        v1 = Result.exceptionOrNull-impl((Object)it);
                        Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type at.asitplus.attestation.android.exceptions.CertificateInvalidException");
                        if (((CertificateInvalidException)v1).getReason() == CertificateInvalidException.Reason.TIME) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        v3 = element$iv;
                        break block16;
                    }
                    v3 = null;
                }
                var7_9 = v3;
                if (var7_9 != null && (var8_12 = Result.exceptionOrNull-impl((Object)var7_9.unbox-impl())) != null) {
                    it = var8_12;
                    $i$a$-let-DefaultAttestationService$verifyAttestationAndroid$1$3 = false;
                    throw it;
                }
                v4 = Result.exceptionOrNull-impl((Object)((Result)CollectionsKt.last((List)results)).unbox-impl());
                Intrinsics.checkNotNull((Object)v4);
                throw v4;
            }
            $this$verifyAttestationAndroid_u24lambda_u2414 = Result.constructor-impl((Object)new AttestationResult.Android.Verified(certificates));
        }
        catch (Throwable $i$a$-runCatching-DefaultAttestationService$verifyAttestationAndroid$1) {
            $this$verifyAttestationAndroid_u24lambda_u2414 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DefaultAttestationService$verifyAttestationAndroid$1));
        }
        var3_3 = $this$verifyAttestationAndroid_u24lambda_u2414;
        v5 = Result.exceptionOrNull-impl((Object)var3_3);
        if (v5 == null) {
            v6 = var3_3;
        } else {
            it = v5;
            $i$a$-getOrElse-DefaultAttestationService$verifyAttestationAndroid$2 = false;
            v7 = it.getMessage();
            if (v7 == null) {
                v7 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
            }
            v6 = new AttestationResult.Error("Android Attestation Error: " + v7, it instanceof CertificateInvalidException != false && ((CertificateInvalidException)it).getReason() == CertificateInvalidException.Reason.TIME ? (AttestationException)new AttestationException.Certificate.Time(Platform.ANDROID, null, it, 2, null) : (it instanceof CertificateException != false || it instanceof CertificateInvalidException != false ? (AttestationException)new AttestationException.Certificate.Trust(Platform.ANDROID, null, it, 2, null) : (AttestationException)new AttestationException.Content(Platform.ANDROID, null, it, 2, null)));
        }
        return (AttestationResult)v6;
    }

    /*
     * WARNING - void declaration
     */
    private final AttestationResult verifyAttestationApple-t-mv6J0(byte[] attestationObject, byte[] expectedChallenge, Pair<? extends byte[], ? extends byte[]> assertionData, long counter) {
        Object object = this;
        try {
            AttestationResult attestationResult;
            block25: {
                Pair result;
                block24: {
                    Object object2;
                    Object iosVersion;
                    Object object3;
                    Object v3;
                    DefaultAttestationService $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426;
                    block23: {
                        Object result2;
                        Object element$iv2;
                        block22: {
                            void $this$filterTo$iv$iv;
                            Pair pair;
                            Iterable $this$mapTo$iv$iv;
                            $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426 = object;
                            boolean bl = false;
                            $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426.log.debug("Verifying iOS attestation");
                            X509CertificateHolder parsedAttestationCert = new X509CertificateHolder((byte[])CollectionsKt.first(((AttestationObject)$this$verifyAttestationApple_t_mv6J0_u24lambda_u2426.appAttestReader.readValue(attestationObject)).getAttStmt().getX5c()));
                            Map<AppleAppAttest, AttestationValidator> $this$map$iv = $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426.attestationValidators;
                            boolean $i$f$map = false;
                            Map<AppleAppAttest, AttestationValidator> map = $this$map$iv;
                            Object destination$iv$iv = new ArrayList($this$map$iv.size());
                            boolean $i$f$mapTo = false;
                            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Object object4;
                                Pair item$iv$iv;
                                pair = item$iv$iv = iterator.next();
                                Collection collection = destination$iv$iv;
                                boolean bl2 = false;
                                AppleAppAttest app = (AppleAppAttest)pair.getKey();
                                AttestationValidator attestationValidator = (AttestationValidator)pair.getValue();
                                DefaultAttestationService defaultAttestationService = $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426;
                                AppleAppAttest appleAppAttest = app;
                                try {
                                    DefaultAttestationService $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426_u24lambda_u2417_u24lambda_u2416 = defaultAttestationService;
                                    boolean bl3 = false;
                                    byte[] byArray = MessageDigest.getInstance("SHA-256").digest(parsedAttestationCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes());
                                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                                    String string = ExtensionsKt.encodeBase64(byArray);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBase64(...)");
                                    object4 = Result.constructor-impl((Object)attestationValidator.validate(attestationObject, string, expectedChallenge));
                                }
                                catch (Throwable throwable) {
                                    object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                }
                                collection.add(TuplesKt.to((Object)appleAppAttest, (Object)Result.box-impl((Object)object4)));
                            }
                            List results = (List)destination$iv$iv;
                            Iterable $this$filter$iv = results;
                            boolean $i$f$filter = false;
                            $this$mapTo$iv$iv = $this$filter$iv;
                            destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
                                pair = (Pair)element$iv$iv;
                                boolean bl4 = false;
                                Object result3 = ((Result)pair.component2()).unbox-impl();
                                if (!Result.isFailure-impl((Object)result3)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            if (((List)destination$iv$iv).size() == results.size()) {
                                Throwable throwable = Result.exceptionOrNull-impl((Object)((Result)((Pair)CollectionsKt.first((List)results)).getSecond()).unbox-impl());
                                Intrinsics.checkNotNull((Object)throwable);
                                throw throwable;
                            }
                            Iterable $this$first$iv = results;
                            boolean $i$f$first = false;
                            for (Object element$iv2 : $this$first$iv) {
                                iterator = (Pair)element$iv2;
                                boolean bl5 = false;
                                result2 = ((Result)iterator.component2()).unbox-impl();
                                if (!Result.isSuccess-impl((Object)result2)) continue;
                                break block22;
                            }
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        Pair pair = (Pair)element$iv2;
                        boolean bl = false;
                        AppleAppAttest app = (AppleAppAttest)pair.component1();
                        Iterator res = ((Result)pair.component2()).unbox-impl();
                        Iterator iterator = Result.isFailure-impl((Object)res) ? null : res;
                        Intrinsics.checkNotNull((Object)iterator);
                        result = TuplesKt.to((Object)app, (Object)iterator);
                        Iterable $this$firstOrNull$iv = $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426.iosApps.entrySet();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv3 : $this$firstOrNull$iv) {
                            result2 = (Map.Entry)element$iv3;
                            boolean bl6 = false;
                            AppleAppAttest appAttest = (AppleAppAttest)result2.getValue();
                            if (!Intrinsics.areEqual((Object)appAttest.getApp(), (Object)((AppleAppAttest)result.getFirst()).getApp())) continue;
                            v3 = element$iv3;
                            break block23;
                        }
                        v3 = null;
                    }
                    if ((object3 = (Map.Entry)v3) == null || (object3 = (IOSAttestationConfiguration.AppData)object3.getKey()) == null || (object3 = ((IOSAttestationConfiguration.AppData)object3).getIosVersionOverride()) == null) {
                        object3 = $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426.iosAttestationConfiguration.getIosVersion();
                    }
                    Object object5 = iosVersion = object3;
                    if (object5 != null) {
                        SemVer configuredVersion;
                        Object it = object5;
                        boolean bl = false;
                        String string = ((ValidatedAttestation)result.getSecond()).getIOSVersion();
                        if (string == null) {
                            return new AttestationResult.Error("Could not parse iOS version from AppAttest", new AttestationException.Content(Platform.IOS, null, null, 6, null));
                        }
                        SemVer parsedVersion = SemVer.Companion.parse(string);
                        if (parsedVersion.compareTo(configuredVersion = SemVer.Companion.parse((String)it)) < 0) {
                            return new AttestationResult.Error("iOS version  " + parsedVersion + " < " + configuredVersion, new AttestationException.Content(Platform.IOS, null, null, 6, null));
                        }
                    }
                    if ((object2 = assertionData) != null) {
                        Pair<? extends byte[], ? extends byte[]> assertionData2 = object2;
                        boolean bl = false;
                        Object object6 = $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426;
                        try {
                            DefaultAttestationService $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426_u24lambda_u2425_u24lambda_u2423 = object6;
                            boolean bl7 = false;
                            AssertionValidator assertionValidator = ((AppleAppAttest)result.getFirst()).createAssertionValidator(new AssertionChallengeValidator(expectedChallenge){
                                final /* synthetic */ byte[] $expectedChallenge;
                                {
                                    this.$expectedChallenge = $expectedChallenge;
                                }

                                public boolean validate(@NotNull Assertion assertionObj, @NotNull byte[] clientData, @NotNull ECPublicKey attestationPublicKey, @NotNull byte[] challenge) {
                                    Intrinsics.checkNotNullParameter((Object)assertionObj, (String)"assertionObj");
                                    Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
                                    Intrinsics.checkNotNullParameter((Object)attestationPublicKey, (String)"attestationPublicKey");
                                    Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
                                    return Arrays.equals(challenge, this.$expectedChallenge);
                                }
                            });
                            byte[] byArray = AssertionData.getAssertion-impl(assertionData2);
                            byte[] byArray2 = AssertionData.getClientData-impl(assertionData2);
                            PublicKey publicKey = ((ValidatedAttestation)result.getSecond()).getCertificate().getPublicKey();
                            Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                            Assertion assertion2 = assertionValidator.validate(byArray, byArray2, (ECPublicKey)publicKey, counter, expectedChallenge);
                            return assertion2.getAuthenticatorData().getSignCount() != 1L ? (AttestationResult)new AttestationResult.Error("iOS Assertion counter is " + assertion2.getAuthenticatorData().getSignCount() + ", but should be 1", new AttestationException.Content(Platform.IOS, null, null, 6, null)) : (AttestationResult)new AttestationResult.IOS.Verified((ValidatedAttestation)result.getSecond(), (Pair<byte[], Assertion>)TuplesKt.to((Object)AssertionData.getClientData-impl(assertionData2), (Object)assertion2));
                        }
                        catch (Throwable bl7) {
                            Object object7;
                            object6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl7));
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object6);
                            if (throwable == null) {
                                object7 = object6;
                            } else {
                                Throwable it = throwable;
                                boolean bl8 = false;
                                Object object8 = it.getMessage();
                                if (object8 == null) {
                                    object8 = "iOS Assertion validation error due to " + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                                }
                                object7 = new AttestationResult.Error((String)object8, $this$verifyAttestationApple_t_mv6J0_u24lambda_u2426.encapsulateIosAttestationException(it));
                            }
                            AttestationResult.Error error = (AttestationResult.Error)object7;
                            object2 = error;
                            if (error == null) break block24;
                            attestationResult = (AttestationResult)object2;
                            break block25;
                        }
                    }
                }
                attestationResult = new AttestationResult.IOS.Verified((ValidatedAttestation)result.getSecond(), null);
            }
            return attestationResult;
        }
        catch (Throwable bl) {
            Object object9;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                object9 = object;
            } else {
                Throwable it = throwable;
                boolean bl9 = false;
                Object object10 = it.getMessage();
                if (object10 == null) {
                    object10 = "iOS Attestation failed due to " + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                }
                object9 = new AttestationResult.Error((String)object10, this.encapsulateIosAttestationException(it));
            }
            return (AttestationResult)object9;
        }
    }

    private final AttestationException encapsulateIosAttestationException(Throwable it) {
        AttestationException attestationException;
        if (it instanceof AttestationException.InvalidCertificateChain || it instanceof ReceiptException.InvalidCertificateChain) {
            Throwable ex = it.getCause();
            while (!(ex instanceof CertPathValidatorException)) {
                if (ex == null) {
                    return new AttestationException.Content(Platform.IOS, null, it, 2, null);
                }
                ex = ex.getCause();
            }
            attestationException = ((CertPathValidatorException)ex).getReason() == CertPathValidatorException.BasicReason.NOT_YET_VALID || ((CertPathValidatorException)ex).getReason() == CertPathValidatorException.BasicReason.EXPIRED ? (AttestationException.Certificate)new AttestationException.Certificate.Time(Platform.IOS, null, ex, 2, null) : (AttestationException.Certificate)new AttestationException.Certificate.Trust(Platform.IOS, null, ex, 2, null);
        } else if (it instanceof AttestationException.InvalidReceipt) {
            Throwable ex = it.getCause();
            while (!(ex instanceof ReceiptException.InvalidPayload)) {
                if (ex == null) {
                    return new AttestationException.Content(Platform.IOS, null, it, 2, null);
                }
                ex = ex.getCause();
            }
            String string = ((ReceiptException.InvalidPayload)ex).getMessage();
            attestationException = (string != null ? StringsKt.startsWith$default((String)string, (String)"Receipt's creation time is after", (boolean)false, (int)2, null) : false) ? (AttestationException)new AttestationException.Certificate.Time(Platform.IOS, null, ex, 2, null) : (AttestationException)new AttestationException.Content(Platform.IOS, null, it, 2, null);
        } else {
            attestationException = new AttestationException.Content(Platform.IOS, null, it, 2, null);
        }
        return attestationException;
    }

    @JvmOverloads
    public DefaultAttestationService(@NotNull AndroidAttestationConfiguration androidAttestationConfigurationJ, @NotNull IOSAttestationConfiguration iosAttestationConfigurationJ, @NotNull java.time.Duration verificationTimeOffsetJ) {
        Intrinsics.checkNotNullParameter((Object)androidAttestationConfigurationJ, (String)"androidAttestationConfigurationJ");
        Intrinsics.checkNotNullParameter((Object)iosAttestationConfigurationJ, (String)"iosAttestationConfigurationJ");
        Intrinsics.checkNotNullParameter((Object)verificationTimeOffsetJ, (String)"verificationTimeOffsetJ");
        this(androidAttestationConfigurationJ, iosAttestationConfigurationJ, verificationTimeOffsetJ, null, 8, null);
    }

    @JvmOverloads
    public DefaultAttestationService(@NotNull AndroidAttestationConfiguration androidAttestationConfigurationJ, @NotNull IOSAttestationConfiguration iosAttestationConfigurationJ) {
        Intrinsics.checkNotNullParameter((Object)androidAttestationConfigurationJ, (String)"androidAttestationConfigurationJ");
        Intrinsics.checkNotNullParameter((Object)iosAttestationConfigurationJ, (String)"iosAttestationConfigurationJ");
        this(androidAttestationConfigurationJ, iosAttestationConfigurationJ, null, null, 12, null);
    }

    public /* synthetic */ DefaultAttestationService(AndroidAttestationConfiguration androidAttestationConfiguration, IOSAttestationConfiguration iosAttestationConfiguration, Clock clock, long verificationTimeOffset, DefaultConstructorMarker $constructor_marker) {
        this(androidAttestationConfiguration, iosAttestationConfiguration, clock, verificationTimeOffset);
    }

    public static final /* synthetic */ AttestationResult access$verifyAttestationApple-t-mv6J0(DefaultAttestationService $this, byte[] attestationObject, byte[] expectedChallenge, Pair assertionData, long counter) {
        return $this.verifyAttestationApple-t-mv6J0(attestationObject, expectedChallenge, (Pair<? extends byte[], ? extends byte[]>)assertionData, counter);
    }
}

