/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.attestation;

import at.asitplus.attestation.AttestationResult;
import at.asitplus.attestation.AttestationService;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0010\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lat/asitplus/attestation/NoopAttestationService;", "Lat/asitplus/attestation/AttestationService;", "()V", "android", "Lat/asitplus/attestation/AttestationService$Android;", "getAndroid", "()Lat/asitplus/attestation/AttestationService$Android;", "ios", "Lat/asitplus/attestation/AttestationService$IOS;", "getIos", "()Lat/asitplus/attestation/AttestationService$IOS;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "verifyAttestation", "Lat/asitplus/attestation/AttestationResult;", "attestationProof", "", "", "challenge", "clientData", "verifyAttestation$attestation_service", "attestation-service"})
public final class NoopAttestationService
extends AttestationService {
    @NotNull
    public static final NoopAttestationService INSTANCE = new NoopAttestationService();
    private static final Logger log = LoggerFactory.getLogger(INSTANCE.getClass());

    private NoopAttestationService() {
    }

    @Override
    @NotNull
    public AttestationResult verifyAttestation$attestation_service(@NotNull List<byte[]> attestationProof, @NotNull byte[] challenge, @Nullable byte[] clientData) {
        Intrinsics.checkNotNullParameter(attestationProof, (String)"attestationProof");
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        return attestationProof.size() > 2 ? (AttestationResult)new AttestationResult.Android.NOOP(attestationProof) : (AttestationResult)new AttestationResult.IOS.NOOP(clientData);
    }

    @Override
    @NotNull
    public AttestationService.IOS getIos() {
        return new AttestationService.IOS(){

            @NotNull
            public AttestationResult verifyAppAttestation(@NotNull byte[] attestationObject, @NotNull byte[] challenge) {
                Intrinsics.checkNotNullParameter((Object)attestationObject, (String)"attestationObject");
                Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
                return NoopAttestationService.INSTANCE.verifyAttestation$attestation_service(CollectionsKt.listOf((Object)attestationObject), challenge, null);
            }

            @NotNull
            public AttestationResult verifyAssertion(@NotNull byte[] attestationObject, @NotNull byte[] assertionFromDevice, @NotNull byte[] referenceClientData, @NotNull byte[] challenge, long counter) {
                Intrinsics.checkNotNullParameter((Object)attestationObject, (String)"attestationObject");
                Intrinsics.checkNotNullParameter((Object)assertionFromDevice, (String)"assertionFromDevice");
                Intrinsics.checkNotNullParameter((Object)referenceClientData, (String)"referenceClientData");
                Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
                byte[][] byArrayArray = new byte[][]{attestationObject, assertionFromDevice};
                return NoopAttestationService.INSTANCE.verifyAttestation$attestation_service(CollectionsKt.listOf((Object[])((Object[])byArrayArray)), challenge, referenceClientData);
            }
        };
    }

    @Override
    @NotNull
    public AttestationService.Android getAndroid() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }
}

