/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.backend.file;

import at.newmedialab.ldpath.backend.sesame.SesameRepositoryBackend;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.openrdf.model.Resource;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBackend
extends SesameRepositoryBackend {
    private static final Logger log = LoggerFactory.getLogger(FileBackend.class);

    public FileBackend(File file) {
        this(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBackend(File file, String mimetype) {
        RDFFormat format = null;
        if (mimetype != null) {
            format = RDFFormat.forMIMEType((String)mimetype);
        }
        try {
            SailRepository repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            this.setRepository((Repository)repository);
            RepositoryConnection connection = repository.getConnection();
            try {
                connection.add(file, null, format, new Resource[0]);
            }
            finally {
                connection.close();
            }
        }
        catch (RDFParseException e) {
            log.error("error parsing RDF input data from file {}", (Object)file, (Object)e);
        }
        catch (IOException e) {
            log.error("I/O error while reading input data from file {}", (Object)file, (Object)e);
        }
        catch (RepositoryException e) {
            log.error("error initialising connection to Sesame in-memory repository", (Throwable)e);
        }
    }

    public FileBackend(String fileName) {
        this(new File(fileName));
    }

    public FileBackend(String fileName, String mimetype) {
        this(new File(fileName), mimetype);
    }

    public FileBackend(URL url) {
        this(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBackend(URL url, String mimetype) {
        RDFFormat format = null;
        if (mimetype != null) {
            format = RDFFormat.forMIMEType((String)mimetype);
        }
        try {
            SailRepository repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            this.setRepository((Repository)repository);
            RepositoryConnection connection = repository.getConnection();
            try {
                connection.add(url, null, format, new Resource[0]);
            }
            finally {
                connection.close();
            }
        }
        catch (RDFParseException e) {
            log.error("error parsing RDF input data from url {}", (Object)url, (Object)e);
        }
        catch (IOException e) {
            log.error("I/O error while reading input data from url {}", (Object)url, (Object)e);
        }
        catch (RepositoryException e) {
            log.error("error initialising connection to Sesame in-memory repository", (Throwable)e);
        }
    }
}

