/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.backend.file;

import at.newmedialab.ldpath.LDPath;
import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.backend.file.FileBackend;
import at.newmedialab.ldpath.exception.LDPathParseException;
import ch.qos.logback.classic.Level;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileQuery {
    private static final Logger log = LoggerFactory.getLogger(FileQuery.class);

    public static void main(String[] args) {
        Options options = FileQuery.buildOptions();
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            Level logLevel = Level.WARN;
            if (cmd.hasOption("loglevel")) {
                String logLevelName = cmd.getOptionValue("loglevel");
                if ("DEBUG".equals(logLevelName.toUpperCase())) {
                    logLevel = Level.DEBUG;
                } else if ("INFO".equals(logLevelName.toUpperCase())) {
                    logLevel = Level.INFO;
                } else if ("WARN".equals(logLevelName.toUpperCase())) {
                    logLevel = Level.WARN;
                } else if ("ERROR".equals(logLevelName.toUpperCase())) {
                    logLevel = Level.ERROR;
                } else {
                    log.error("unsupported log level: {}", (Object)logLevelName);
                }
            }
            if (logLevel != null) {
                for (String logname : new String[]{"at", "org", "net", "com"}) {
                    ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)logname);
                    logger.setLevel(logLevel);
                }
            }
            String format = null;
            if (cmd.hasOption("format")) {
                format = cmd.getOptionValue("format");
            }
            FileBackend backend = null;
            if (cmd.hasOption("file")) {
                backend = new FileBackend(cmd.getOptionValue("file"), format);
            } else if (cmd.hasOption("url")) {
                URL url = new URL(cmd.getOptionValue("url"));
                backend = new FileBackend(url, format);
            }
            URI context = null;
            if (cmd.hasOption("context")) {
                context = backend.getRepository().getValueFactory().createURI(cmd.getOptionValue("context"));
            }
            if (backend != null && context != null) {
                LDPath ldpath = new LDPath((RDFBackend)backend);
                if (cmd.hasOption("path")) {
                    String path = cmd.getOptionValue("path");
                    for (Value v : ldpath.pathQuery((Object)context, path, null)) {
                        System.out.println(v.stringValue());
                    }
                } else if (cmd.hasOption("program")) {
                    File file = new File(cmd.getOptionValue("program"));
                    Map result = ldpath.programQuery((Object)context, (Reader)new FileReader(file));
                    for (String field : result.keySet()) {
                        StringBuilder line = new StringBuilder();
                        line.append(field);
                        line.append(" = ");
                        line.append("{");
                        Iterator it = ((Collection)result.get(field)).iterator();
                        while (it.hasNext()) {
                            line.append(it.next().toString());
                            if (!it.hasNext()) continue;
                            line.append(", ");
                        }
                        line.append("}");
                        System.out.println(line);
                    }
                }
            }
        }
        catch (ParseException e) {
            System.err.println("invalid arguments");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("FileQuery", options, true);
        }
        catch (MalformedURLException e) {
            System.err.println("url could not be parsed");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("FileQuery", options, true);
        }
        catch (LDPathParseException e) {
            System.err.println("path or program could not be parsed");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.err.println("file or program could not be found");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("FileQuery", options, true);
        }
    }

    private static Options buildOptions() {
        Options result = new Options();
        OptionGroup input = new OptionGroup();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"query the contents of a file");
        Option file = OptionBuilder.create((String)"file");
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"query the contents of a remote URL");
        Option url = OptionBuilder.create((String)"url");
        input.addOption(file);
        input.addOption(url);
        input.setRequired(true);
        result.addOptionGroup(input);
        OptionBuilder.withArgName((String)"mimetype");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"MIME type of the input document");
        Option format = OptionBuilder.create((String)"format");
        result.addOption(format);
        OptionGroup query = new OptionGroup();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"LD Path to evaluate on the file starting from the context");
        Option path = OptionBuilder.create((String)"path");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"LD Path program to evaluate on the file starting from the context");
        Option program = OptionBuilder.create((String)"program");
        query.addOption(path);
        query.addOption(program);
        query.setRequired(true);
        result.addOptionGroup(query);
        OptionBuilder.withArgName((String)"uri");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"URI of the context node to start from");
        Option context = OptionBuilder.create((String)"context");
        context.setRequired(true);
        result.addOption(context);
        OptionBuilder.withArgName((String)"level");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set the log level; default is 'warn'");
        Option loglevel = OptionBuilder.create((String)"loglevel");
        result.addOption(loglevel);
        return result;
    }
}

