/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.examples;

import au.csiro.ontology.Factory;
import au.csiro.ontology.Node;
import au.csiro.ontology.Ontology;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.Concept;
import au.csiro.ontology.model.NamedRole;
import au.csiro.ontology.model.Role;
import au.csiro.snorocket.core.SnorocketReasoner;
import java.util.HashSet;
import java.util.Set;

public class APIExample {
    public static void main(String[] args) {
        Concept heartInflammation;
        System.out.println("Running Snorocket API Example");
        SnorocketReasoner reasoner = new SnorocketReasoner();
        HashSet<Axiom> baseAxioms = new HashSet<Axiom>();
        Concept endocardium = Factory.createNamedConcept((String)"Endocardium");
        Concept tissue = Factory.createNamedConcept((String)"Tissue");
        Concept heartWall = Factory.createNamedConcept((String)"HeartWall");
        Concept heartValve = Factory.createNamedConcept((String)"HeartValve");
        Concept bodyWall = Factory.createNamedConcept((String)"BodyWall");
        Concept heart = Factory.createNamedConcept((String)"Heart");
        Concept bodyValve = Factory.createNamedConcept((String)"BodyValve");
        Concept endocarditis = Factory.createNamedConcept((String)"Endocarditis");
        Concept inflammation = Factory.createNamedConcept((String)"Inflammation");
        Concept disease = Factory.createNamedConcept((String)"Disease");
        Concept heartDisease = Factory.createNamedConcept((String)"HeartDisease");
        Concept criticalDisease = Factory.createNamedConcept((String)"CriticalDisease");
        Role actsOn = Factory.createNamedRole((String)"acts-on");
        Role partOf = Factory.createNamedRole((String)"part-of");
        Role contIn = Factory.createNamedRole((String)"cont-in");
        Role hasLoc = Factory.createNamedRole((String)"has-loc");
        Concept lhs = endocardium;
        Concept rhs = Factory.createConjunction((Concept[])new Concept[]{tissue, Factory.createExistential((Role)((NamedRole)contIn), (Concept)heartWall), Factory.createExistential((Role)((NamedRole)contIn), (Concept)heartValve)});
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = heartWall;
        rhs = Factory.createConjunction((Concept[])new Concept[]{bodyWall, Factory.createExistential((Role)((NamedRole)partOf), (Concept)heart)});
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = heartValve;
        rhs = Factory.createConjunction((Concept[])new Concept[]{bodyValve, Factory.createExistential((Role)((NamedRole)partOf), (Concept)heart)});
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = endocarditis;
        rhs = Factory.createConjunction((Concept[])new Concept[]{inflammation, Factory.createExistential((Role)((NamedRole)hasLoc), (Concept)endocardium)});
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = inflammation;
        rhs = Factory.createConjunction((Concept[])new Concept[]{disease, Factory.createExistential((Role)actsOn, (Concept)tissue)});
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = Factory.createConjunction((Concept[])new Concept[]{heartDisease, Factory.createExistential((Role)hasLoc, (Concept)heartValve)});
        rhs = criticalDisease;
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = heartDisease;
        rhs = Factory.createConjunction((Concept[])new Concept[]{disease, Factory.createExistential((Role)hasLoc, (Concept)heart)});
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        baseAxioms.add(Factory.createConceptInclusion((Concept)rhs, (Concept)lhs));
        Role[] rlhs = new Role[]{partOf, partOf};
        Role rrhs = partOf;
        baseAxioms.add(Factory.createRoleInclusion((Role[])rlhs, (Role)rrhs));
        rlhs = new Role[]{partOf};
        rrhs = contIn;
        baseAxioms.add(Factory.createRoleInclusion((Role[])rlhs, (Role)rrhs));
        rlhs = new Role[]{hasLoc, contIn};
        rrhs = hasLoc;
        baseAxioms.add(Factory.createRoleInclusion((Role[])rlhs, (Role)rrhs));
        reasoner.loadAxioms(baseAxioms);
        reasoner.classify();
        Ontology t = reasoner.getClassifiedOntology();
        Node endocarditisNode = t.getNode("Endocarditis");
        System.out.println("Node for endocarditis:\n  " + endocarditisNode.getEquivalentConcepts());
        Set parentNodes = endocarditisNode.getParents();
        System.out.println("Parents of endocarditis:");
        for (Node parentNode : parentNodes) {
            System.out.println("  " + parentNode.getEquivalentConcepts());
        }
        HashSet<Axiom> additionalAxioms = new HashSet<Axiom>();
        lhs = heartInflammation = Factory.createNamedConcept((String)"HeartInflammation");
        rhs = inflammation;
        additionalAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = endocarditis;
        rhs = Factory.createConjunction((Concept[])new Concept[]{heartInflammation, Factory.createExistential((Role)hasLoc, (Concept)endocardium)});
        additionalAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        System.out.println("Running incremental classification:");
        reasoner.loadAxioms(additionalAxioms);
        reasoner.classify();
        t = reasoner.getClassifiedOntology();
        endocarditisNode = t.getNode("Endocarditis");
        System.out.println("Node for endocarditis:\n  " + endocarditisNode.getEquivalentConcepts());
        parentNodes = endocarditisNode.getParents();
        System.out.println("Parents of endocarditis:");
        for (Node parentNode : parentNodes) {
            System.out.println("  " + parentNode.getEquivalentConcepts());
        }
    }
}

