/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.apache.avalon.activation.ComponentFactory;
import org.apache.avalon.activation.LifecycleException;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.StageModel;
import org.apache.avalon.composition.provider.LifestyleManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.lifecycle.Accessor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public abstract class AbstractLifestyleManager
implements LifestyleManager {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$activation$impl$AbstractLifestyleManager == null ? (class$org$apache$avalon$activation$impl$AbstractLifestyleManager = AbstractLifestyleManager.class$("org.apache.avalon.activation.impl.AbstractLifestyleManager")) : class$org$apache$avalon$activation$impl$AbstractLifestyleManager));
    private final ComponentModel m_model;
    private final ComponentFactory m_factory;
    private final Logger m_logger;
    private final ReferenceQueue m_liberals = new ReferenceQueue();
    static /* synthetic */ Class class$org$apache$avalon$activation$impl$AbstractLifestyleManager;
    static /* synthetic */ Class class$org$apache$avalon$lifecycle$Accessor;

    public AbstractLifestyleManager(ComponentModel model, ComponentFactory factory) {
        this.m_factory = factory;
        this.m_model = model;
        this.m_logger = model.getLogger();
    }

    public abstract void commission() throws Exception;

    public abstract void decommission();

    public Object resolve() throws Exception {
        Object instance = this.handleResolve();
        return this.applyExtensionStages(instance, true);
    }

    public Object resolve(boolean proxy) throws Exception {
        return this.resolve();
    }

    public void release(Object instance) {
        try {
            this.applyExtensionStages(instance, false);
        }
        catch (Throwable e) {
            String error = "Ignoring error returned from release extension.";
            this.getLogger().error("Ignoring error returned from release extension.", e);
        }
        this.handleRelease(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize(Object instance) {
        ComponentFactory componentFactory = this.m_factory;
        synchronized (componentFactory) {
            if (instance != null) {
                this.m_factory.etherialize(instance);
            }
        }
    }

    protected abstract Object handleResolve() throws Exception;

    protected abstract void handleRelease(Object var1);

    protected Logger getLogger() {
        return this.m_logger;
    }

    protected ComponentModel getComponentModel() {
        return this.m_model;
    }

    protected ComponentFactory getComponentFactory() {
        return this.m_factory;
    }

    ReferenceQueue getLiberalQueue() {
        return this.m_liberals;
    }

    protected Reference getReference(Object instance) {
        int policy = this.getComponentModel().getCollectionPolicy();
        if (policy == 0) {
            return new WeakReference<Object>(instance, this.m_liberals);
        }
        if (policy == 1) {
            return new SoftReference<Object>(instance);
        }
        return new StrongReference(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object applyExtensionStages(Object instance, boolean flag) throws Exception {
        StageDescriptor[] stages = this.m_model.getType().getStages();
        for (int i = 0; i < stages.length; ++i) {
            StageDescriptor descriptor;
            StageModel stage;
            ComponentModel provider;
            Class c;
            if (!(class$org$apache$avalon$lifecycle$Accessor == null ? AbstractLifestyleManager.class$("org.apache.avalon.lifecycle.Accessor") : class$org$apache$avalon$lifecycle$Accessor).isAssignableFrom(c = (provider = this.getStageProvider(stage = this.m_model.getStageModel(descriptor = stages[i]))).getDeploymentClass())) continue;
            Accessor handler = (Accessor)provider.resolve();
            try {
                Context context = (Context)this.m_model.getContextModel().getContext();
                if (flag) {
                    if (this.getLogger().isDebugEnabled()) {
                        int id = System.identityHashCode(instance);
                        this.getLogger().debug("applying access stage to: " + id);
                    }
                    handler.access(instance, context);
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    int id = System.identityHashCode(instance);
                    this.getLogger().debug("applying release stage to: " + id);
                }
                handler.release(instance, context);
                continue;
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.stage.accessor.error", (Object)stage.getStage().getKey());
                if (flag) {
                    throw new LifecycleException(error, e);
                }
                this.getLogger().warn(error, e);
                continue;
            }
            finally {
                provider.release((Object)handler);
            }
        }
        return instance;
    }

    private ComponentModel getStageProvider(StageModel stage) throws LifecycleException {
        try {
            return (ComponentModel)stage.getProvider();
        }
        catch (Throwable e) {
            String error = "Unable to resolve access stage provider.";
            throw new LifecycleException("Unable to resolve access stage provider.", e);
        }
    }

    public void finalize() {
        this.decommission();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StrongReference
    extends WeakReference {
        private final Object m_instance;

        public StrongReference(Object instance) {
            super(instance);
            this.m_instance = instance;
        }

        public Object get() {
            return this.m_instance;
        }
    }
}

