/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.models.impl;

import be.orbinson.aem.dictionarytranslator.models.Dictionary;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Named;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Dictionary.class})
public class DictionaryImpl
implements Dictionary {
    @SlingObject
    private SlingHttpServletRequest request;
    @SlingObject
    private Resource resource;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Named(value="jcr:created")
    private Calendar created;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Named(value="jcr:lastModified")
    private Calendar lastModified;
    @OSGiService
    private DictionaryService dictionaryService;

    @Override
    public String getLanguageList() {
        return String.join((CharSequence)", ", this.getLanguages());
    }

    private String getDateString(Date date) {
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, this.request.getLocale());
        return formatter.format(date);
    }

    @Override
    public String getLastModifiedFormatted() {
        return this.getDateString(this.getLastModified().getTime());
    }

    @Override
    public Calendar getLastModified() {
        return this.lastModified == null ? this.getCreated() : this.lastModified;
    }

    @Override
    public List<String> getLanguages() {
        return this.dictionaryService.getLanguages(this.resource);
    }

    @Override
    public boolean isEditable() {
        return this.resource.getPath().startsWith("/content");
    }

    @Override
    @NotNull
    public Resource getResource() {
        return this.resource;
    }

    @Override
    @Nullable
    public Calendar getCreated() {
        return this.created;
    }

    @Override
    public String getBasename() {
        return this.dictionaryService.getBasename(this.resource);
    }

    @Override
    public int getLabelCount() {
        return this.getKeys().size();
    }

    @Override
    public List<String> getKeys() {
        TreeSet keys = new TreeSet();
        for (String language : this.dictionaryService.getLanguages(this.resource)) {
            Resource child = this.resource.getChild(language);
            if (child == null) continue;
            child.listChildren().forEachRemaining(item -> DictionaryImpl.addKey(keys, item));
        }
        return List.copyOf(keys);
    }

    private static void addKey(Set<String> keys, Resource item) {
        if (item.isResourceType("sling:MessageEntry")) {
            keys.add(item.getName());
        }
    }
}

