/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.services;

import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.text.Text;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ResourceProvider.class}, property={"provider.root=/mnt/dictionary", "provider.modifiable=true"})
public class LabelResourceProvider
extends ResourceProvider<Object> {
    public static final String ROOT = "/mnt/dictionary";
    public static final String RESOURCE_TYPE = "aem-dictionary-translator/components/label";
    public static final String LANGUAGES = "languages";
    @Reference
    private DictionaryService dictionaryService;

    public void delete(@NotNull ResolveContext<Object> ctx, @NotNull Resource resource) throws PersistenceException {
        ValueMap properties = resource.getValueMap();
        if (properties.containsKey((Object)LANGUAGES) && properties.containsKey((Object)"name")) {
            ResourceResolver resourceResolver = ctx.getResourceResolver();
            String[] languages = (String[])properties.get(LANGUAGES, String[].class);
            String dictionaryPath = (String)properties.get("dictionaryPath", String.class);
            String name = (String)properties.get("name", String.class);
            if (StringUtils.isNotEmpty((CharSequence)name) && languages != null) {
                for (String language : languages) {
                    Resource labelResource = resourceResolver.getResource(dictionaryPath + "/" + language + "/" + name);
                    if (labelResource == null) continue;
                    resourceResolver.delete(labelResource);
                }
                resourceResolver.commit();
            }
        }
    }

    private Map<String, Object> getValues(Resource dictionaryResource, String labelName) {
        HashMap<String, Object> keys = new HashMap<String, Object>();
        for (String language : this.dictionaryService.getLanguages(dictionaryResource)) {
            Resource labelResource;
            Resource languageResource = dictionaryResource.getChild(language);
            if (languageResource == null || (labelResource = languageResource.getChild(labelName)) == null || !labelResource.getValueMap().containsKey((Object)"sling:message")) continue;
            keys.put(language, labelResource.getValueMap().get("sling:message", String.class));
        }
        return keys;
    }

    @Nullable
    public Resource getResource(@NotNull ResolveContext<Object> ctx, @NotNull String path, @NotNull ResourceContext resourceContext, @Nullable Resource parent) {
        ResourceResolver resourceResolver = ctx.getResourceResolver();
        if (!path.startsWith(ROOT) || ROOT.equals(path)) {
            return null;
        }
        String labelName = Text.getName((String)path);
        String dictionaryPath = Text.getRelativeParent((String)path, (int)1).replaceFirst(ROOT, "");
        Resource dictionaryResource = resourceResolver.getResource(dictionaryPath);
        if (dictionaryResource != null && this.isLabel(dictionaryResource, labelName)) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("name", labelName);
            properties.put("key", this.getKey(dictionaryResource, labelName));
            properties.put("path", path);
            properties.put("dictionaryPath", dictionaryPath);
            properties.put(LANGUAGES, this.dictionaryService.getLanguages(dictionaryResource));
            properties.putAll(this.getValues(dictionaryResource, labelName));
            return new ValueMapResource(resourceResolver, path, RESOURCE_TYPE, (ValueMap)new ValueMapDecorator(properties));
        }
        return null;
    }

    private boolean isLabel(Resource dictionaryResource, String labelName) {
        String firstLanguage;
        Resource languageResource;
        List<String> languages = this.dictionaryService.getLanguages(dictionaryResource);
        if (!languages.isEmpty() && (languageResource = dictionaryResource.getChild(firstLanguage = languages.get(0))) != null) {
            Resource labelResource = languageResource.getChild(labelName);
            return labelResource != null && labelResource.isResourceType("sling:MessageEntry");
        }
        return false;
    }

    private String getKey(Resource dictionaryResource, String labelName) {
        Resource labelResource;
        String firstLanguage;
        Resource languageResource;
        List<String> languages = this.dictionaryService.getLanguages(dictionaryResource);
        if (!languages.isEmpty() && (languageResource = dictionaryResource.getChild(firstLanguage = languages.get(0))) != null && (labelResource = languageResource.getChild(labelName)) != null && labelResource.getValueMap().containsKey((Object)"sling:key")) {
            return (String)labelResource.getValueMap().get("sling:key", String.class);
        }
        return labelName;
    }

    @Nullable
    public Iterator<Resource> listChildren(@NotNull ResolveContext<Object> ctx, @NotNull Resource parent) {
        return Collections.emptyIterator();
    }
}

