/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.services.impl;

import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import com.adobe.granite.translation.api.TranslationConfig;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class DictionaryServiceImpl
implements DictionaryService {
    private static final Logger LOG = LoggerFactory.getLogger(DictionaryServiceImpl.class);
    @Reference
    private TranslationConfig translationConfig;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    public void addLanguage(Resource dictionary, String language, String basename) throws PersistenceException {
        HashMap<String, String> properties = new HashMap<String, String>();
        ResourceResolver resourceResolver = dictionary.getResourceResolver();
        properties.put("sling:resourceType", "sling:Folder");
        properties.put("jcr:language", language);
        properties.put("jcr:mixinTypes", "mix:language");
        if (StringUtils.isNotEmpty((CharSequence)basename)) {
            properties.put("sling:basename", basename);
        } else {
            properties.put("sling:basename", dictionary.getPath());
        }
        LOG.debug("Add language '{}' to dictionary '{}' with properties '{}'", new Object[]{language, dictionary, properties});
        resourceResolver.create(dictionary, language, properties);
        resourceResolver.commit();
    }

    private ResourceResolver getServiceResourceResolver() throws LoginException {
        Map<String, String> authenticationInfo = Map.of("sling.service.subservice", "dictionary-service");
        return this.resourceResolverFactory.getServiceResourceResolver(authenticationInfo);
    }

    @Override
    @NotNull
    public Map<String, String> getLanguagesForPath(ResourceResolver resourceResolver, String path) {
        HashMap<String, String> result = new HashMap<String, String>();
        Resource resource = resourceResolver.getResource(path);
        if (resource != null && this.translationConfig != null) {
            try (ResourceResolver serviceResourceResolver = this.getServiceResourceResolver();){
                Map languages = this.translationConfig.getLanguages(serviceResourceResolver);
                resource.getChildren().forEach(child -> {
                    String language;
                    if (child.getValueMap().containsKey((Object)"jcr:language") && (language = (String)child.getValueMap().get("jcr:language", String.class)) != null) {
                        String label = (String)languages.get(language);
                        LOG.trace("Add language '{}' with label '{}'", (Object)language, (Object)label);
                        result.put(language, label);
                    }
                });
            }
            catch (LoginException e) {
                LOG.error("Unable to get service resource resolver to get languages", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    @NotNull
    public List<Resource> getDictionaries(ResourceResolver resourceResolver) {
        TreeMap result = new TreeMap();
        resourceResolver.findResources("//element(*, mix:language)[@jcr:language]/..", "xpath").forEachRemaining(resource -> result.put(resource.getPath(), resource));
        return new ArrayList<Resource>(result.values());
    }

    @Override
    public List<String> getLanguages(Resource resource) {
        ArrayList<String> result = new ArrayList<String>();
        resource.listChildren().forEachRemaining(child -> {
            ValueMap properties = child.getValueMap();
            if (properties.containsKey((Object)"jcr:language")) {
                LOG.trace("Found language with path '{}'", (Object)child.getPath());
                result.add((String)properties.get("jcr:language", String.class));
            }
        });
        return result;
    }

    @Override
    public String getBasename(Resource dictionaryResource) {
        AtomicReference basename = new AtomicReference();
        dictionaryResource.listChildren().forEachRemaining(child -> {
            ValueMap properties = child.getValueMap();
            if (properties.containsKey((Object)"jcr:language") && basename.get() == null) {
                LOG.trace("Found language with path '{}'", (Object)child.getPath());
                basename.set((String)properties.get("sling:basename", String.class));
            }
        });
        return (String)basename.get();
    }

    @Override
    public void createDictionary(Resource parent, String name, String[] languages, String basename) throws PersistenceException {
        LOG.debug("Create dictionary '{}'", (Object)name);
        ResourceResolver resourceResolver = parent.getResourceResolver();
        String dictionaryPath = parent.getPath() + "/" + JcrUtil.createValidName((String)name) + "/i18n";
        Resource dictionaryResource = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)dictionaryPath, (String)"sling:Folder", (String)"sling:Folder", (boolean)true);
        for (String language : languages) {
            this.addLanguage(dictionaryResource, language, basename);
        }
    }
}

