/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/create-language"}, methods={"POST"})
public class CreateLanguageServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(CreateLanguageServlet.class);
    @Reference
    private transient DictionaryService dictionaryService;

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        block5: {
            String dictionary = request.getParameter("dictionary");
            String language = request.getParameter("language");
            String basename = request.getParameter("basename");
            if (StringUtils.isNotEmpty((CharSequence)dictionary) && StringUtils.isNotEmpty((CharSequence)language)) {
                ResourceResolver resourceResolver = request.getResourceResolver();
                Resource resource = resourceResolver.getResource(dictionary);
                try {
                    if (resource != null) {
                        LOG.debug("Adding language '{}' to dictionary '{}'", (Object)language, (Object)dictionary);
                        this.dictionaryService.addLanguage(resource, language, basename);
                        break block5;
                    }
                    LOG.warn("Unable to get dictionary '{}'", (Object)dictionary);
                    response.sendError(400);
                }
                catch (PersistenceException e) {
                    LOG.error("Unable to add language '{}' to dictionary '{}'", (Object)language, (Object)dictionary);
                    response.sendError(500);
                }
            } else {
                LOG.warn("Dictionary and language parameter are required to add a language to a dictionary");
                response.sendError(400);
            }
        }
    }
}

