/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/delete-dictionary"}, methods={"POST"})
public class DeleteDictionaryServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteDictionaryServlet.class);

    protected void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String dictionaries = request.getParameter("dictionaries");
        if (StringUtils.isNotEmpty((CharSequence)dictionaries)) {
            ResourceResolver resourceResolver = request.getResourceResolver();
            for (String dictionary : dictionaries.split(",")) {
                Resource resource = resourceResolver.getResource(dictionary);
                if (resource != null) {
                    LOG.debug("Delete dictionary '{}'", (Object)dictionary);
                    resourceResolver.delete(resource);
                } else {
                    LOG.warn("Dictionary '{}' not found to delete", (Object)dictionary);
                }
                try {
                    resourceResolver.commit();
                }
                catch (PersistenceException e) {
                    LOG.error("Error deleting item: {}", (Object)dictionary, (Object)e);
                    response.sendError(500, e.getMessage());
                }
            }
        } else {
            LOG.warn("Dictionary parameter can not be empty");
            response.sendError(400);
        }
    }
}

