/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/delete-label"}, methods={"POST"})
public class DeleteLabelServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteLabelServlet.class);

    protected void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String labels = request.getParameter("labels");
        if (StringUtils.isEmpty((CharSequence)labels)) {
            LOG.warn("Labels parameters are required");
            response.sendError(400);
        } else {
            for (String label : labels.split(",")) {
                ResourceResolver resourceResolver = request.getResourceResolver();
                Resource resource = resourceResolver.getResource(label);
                try {
                    if (resource != null) {
                        LOG.debug("Delete label on path '{}'", (Object)label);
                        resourceResolver.delete(resource);
                        continue;
                    }
                    LOG.warn("Unable to get label '{}'", (Object)labels);
                    response.sendError(400);
                }
                catch (PersistenceException e) {
                    LOG.error("Unable to delete labels '{}'", (Object)labels);
                    response.sendError(500);
                }
            }
        }
    }
}

