/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/delete-language"}, methods={"POST"})
public class DeleteLanguageServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteLanguageServlet.class);

    public void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        block5: {
            String language = request.getParameter("language");
            String dictionary = request.getParameter("dictionary");
            if (StringUtils.isNotEmpty((CharSequence)dictionary) && StringUtils.isNotEmpty((CharSequence)language)) {
                ResourceResolver resourceResolver = request.getResourceResolver();
                String path = dictionary + "/" + language;
                Resource resource = resourceResolver.getResource(path);
                try {
                    if (resource != null) {
                        LOG.debug("Delete language '{}' from '{}'", (Object)language, (Object)dictionary);
                        resourceResolver.delete(resource);
                        resourceResolver.commit();
                        break block5;
                    }
                    LOG.warn("Unable to find dictionary '{}'", (Object)path);
                    response.sendError(400);
                }
                catch (PersistenceException e) {
                    LOG.error("Unable to delete language '{}' from dictionary '{}'", (Object)language, (Object)dictionary);
                    response.sendError(500);
                }
            } else {
                LOG.warn("Language and dictionary parameter are required");
                response.sendError(400);
            }
        }
    }
}

