/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/update-label"}, methods={"POST"})
public class UpdateLabelServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateLabelServlet.class);
    @Reference
    private transient DictionaryService dictionaryService;

    protected void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String label = request.getParameter("label");
        if (StringUtils.isEmpty((CharSequence)label)) {
            LOG.warn("Label parameter is required");
            response.sendError(400);
        } else {
            ResourceResolver resourceResolver = request.getResourceResolver();
            Resource resource = resourceResolver.getResource(label);
            try {
                if (resource != null) {
                    this.updateLabel(request, resourceResolver, resource);
                } else {
                    LOG.warn("Unable to get label '{}'", (Object)label);
                    response.sendError(400);
                }
            }
            catch (Exception e) {
                LOG.error("Unable to update label '{}'", (Object)label);
                response.sendError(500);
            }
        }
    }

    private void updateLabel(SlingHttpServletRequest request, ResourceResolver resourceResolver, Resource resource) throws Exception {
        String dictionaryPath = (String)resource.getValueMap().get("dictionaryPath", String.class);
        if (StringUtils.isNotBlank((CharSequence)dictionaryPath)) {
            String[] languages;
            Resource dictionaryResource = resourceResolver.getResource(dictionaryPath);
            String name = resource.getName();
            for (String language : languages = (String[])resource.getValueMap().get("languages", (Object)new String[0])) {
                String message = request.getParameter(language);
                this.addMessage(resourceResolver, dictionaryResource, language, name, message);
            }
        } else {
            throw new Exception("Could not find dictionary path");
        }
    }

    private void addMessage(ResourceResolver resourceResolver, Resource dictionary, String language, String name, String message) {
        Resource languageResource = dictionary.getChild(language);
        if (languageResource != null) {
            try {
                Resource labelResource = languageResource.getChild(name);
                if (labelResource != null) {
                    ValueMap valueMap = (ValueMap)labelResource.adaptTo(ModifiableValueMap.class);
                    valueMap.put((Object)"sling:message", (Object)message);
                    LOG.trace("Updated label with name '{}' and message '{}' on path '{}'", new Object[]{name, message, labelResource.getPath()});
                }
                resourceResolver.commit();
            }
            catch (PersistenceException e) {
                LOG.error("Unable to update label for name '{}'", (Object)name);
            }
        }
    }
}

