/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.datasource;

import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"aem-dictionary-translator/datasource/available-language"}, methods={"GET"})
public class AvailableLanguageDatasource
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AvailableLanguageDatasource.class);
    @Reference
    transient TranslationConfig translationConfig;

    public static Map<String, String> sortByValue(Map<String, String> languageMap) {
        LinkedList<Map.Entry<String, String>> list = new LinkedList<Map.Entry<String, String>>(languageMap.entrySet());
        list.sort(Map.Entry.comparingByValue());
        LinkedHashMap<String, String> temp = new LinkedHashMap<String, String>();
        for (Map.Entry entry : list) {
            temp.put((String)entry.getKey(), (String)entry.getValue());
        }
        return temp;
    }

    public static void filterExistingLanguages(Map<String, String> languageMap, ResourceResolver resourceResolver, String languagePath) {
        Resource resource = resourceResolver.getResource(languagePath);
        ArrayList currentSelectedLanguages = new ArrayList();
        if (resource != null) {
            resourceResolver.getChildren(resource).iterator().forEachRemaining(l -> currentSelectedLanguages.add(l.getPath().replace(languagePath + "/", "")));
            currentSelectedLanguages.forEach(languageMap::remove);
        }
    }

    protected void doGet(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        LOG.debug("Build languages datasource");
        ResourceResolver resourceResolver = request.getResourceResolver();
        String languageParameter = request.getRequestPathInfo().getSuffix();
        HashMap<String, String> languageMap = new HashMap<String, String>(this.translationConfig.getLanguages(resourceResolver));
        AvailableLanguageDatasource.filterExistingLanguages(languageMap, resourceResolver, languageParameter);
        Map<String, String> sortedLanguageMap = AvailableLanguageDatasource.sortByValue(languageMap);
        ArrayList resourceList = new ArrayList();
        sortedLanguageMap.forEach((key, value) -> {
            String text = String.format("%s (%s)", value, key);
            ValueMapDecorator valueMap = new ValueMapDecorator(Map.of("value", key, "text", text));
            LOG.debug("Add language '{}' to datasource with key '{}'", (Object)text, key);
            resourceList.add(new ValueMapResource(resourceResolver, "", "", (ValueMap)valueMap));
        });
        SimpleDataSource dataSource = new SimpleDataSource(resourceList.iterator());
        request.setAttribute(DataSource.class.getName(), (Object)dataSource);
    }
}

