/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.datasource;

import be.orbinson.aem.dictionarytranslator.models.Dictionary;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"aem-dictionary-translator/datasource/label"}, methods={"GET"})
public class LabelDatasource
extends SlingSafeMethodsServlet {
    @Reference
    private transient ModelFactory modelFactory;

    private static void setColumnsDataSource(ResourceResolver resourceResolver, List<Resource> resourceList, Dictionary dictionary) {
        resourceList.add((Resource)LabelDatasource.getColumn(resourceResolver, "select", true));
        resourceList.add((Resource)LabelDatasource.getColumn(resourceResolver, "jcr:title", "key"));
        dictionary.getLanguages().forEach(language -> resourceList.add((Resource)LabelDatasource.getColumn(resourceResolver, "jcr:title", language)));
    }

    @NotNull
    private static ValueMapResource getColumn(ResourceResolver resourceResolver, String key, Object value) {
        ValueMapDecorator valueMap = new ValueMapDecorator(Map.of(key, value));
        return new ValueMapResource(resourceResolver, "", "", (ValueMap)valueMap);
    }

    private static void setDataSource(ResourceResolver resourceResolver, List<Resource> resourceList, Dictionary dictionary) {
        for (String key : dictionary.getKeys()) {
            String path = "/mnt/dictionary" + dictionary.getResource().getPath() + "/" + key;
            Resource keyResource = resourceResolver.getResource(path);
            if (keyResource == null) continue;
            resourceList.add(keyResource);
        }
    }

    private static void createTextFieldResource(ResourceResolver resourceResolver, List<Resource> resourceList, String key, String value) {
        LabelDatasource.createTextFieldResource(resourceResolver, resourceList, key, value, false, false);
    }

    private static void createTextFieldResource(ResourceResolver resourceResolver, List<Resource> resourceList, String key, String value, boolean required, boolean disabled) {
        ValueMapDecorator valueMap = new ValueMapDecorator(Map.of("fieldLabel", key, "name", key, "value", value, "disabled", disabled, "required", required));
        resourceList.add((Resource)new ValueMapResource(resourceResolver, "", "granite/ui/components/coral/foundation/form/textfield", (ValueMap)valueMap));
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        Resource resource;
        String labelPath;
        Dictionary dictionary;
        Resource dictionaryResource;
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        ResourceResolver resourceResolver = request.getResourceResolver();
        String dictionaryPath = request.getRequestPathInfo().getSuffix();
        if (dictionaryPath != null && (dictionaryResource = resourceResolver.getResource(dictionaryPath)) != null && (dictionary = (Dictionary)this.modelFactory.getModelFromWrappedRequest(request, dictionaryResource, Dictionary.class)) != null) {
            if ("columnsdatasource".equals(request.getResource().getName())) {
                LabelDatasource.setColumnsDataSource(resourceResolver, resourceList, dictionary);
            } else {
                LabelDatasource.setDataSource(resourceResolver, resourceList, dictionary);
            }
        }
        if ((labelPath = request.getParameter("label")) != null && (resource = resourceResolver.getResource(labelPath)) != null) {
            ValueMap properties = resource.getValueMap();
            String[] languages = (String[])properties.get("languages", String[].class);
            LabelDatasource.createTextFieldResource(resourceResolver, resourceList, "Label", (String)properties.get("key", String.class), false, true);
            if (languages != null) {
                for (String language : languages) {
                    String label = (String)properties.get(language, (Object)"");
                    LabelDatasource.createTextFieldResource(resourceResolver, resourceList, language, label);
                }
            }
        }
        SimpleDataSource dataSource = new SimpleDataSource(resourceList.iterator());
        request.setAttribute(DataSource.class.getName(), (Object)dataSource);
    }
}

