package be.valuya.bob.core.reader;

import be.valuya.advantaje.core.AdvantajeRecord;
import be.valuya.bob.core.domain.BobCompany;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;

public class BobCompanyRecordReader {

    public BobCompany readCompany(AdvantajeRecord advantajeRecord) {
        String cId = advantajeRecord.getValue("CID");
        Optional<String> cCustomerType = advantajeRecord.getValueOptional("CCUSTYPE");
        Optional<String> cSupplierType = advantajeRecord.getValueOptional("CSUPTYPE");
        Optional<String> cName1 = advantajeRecord.getValueOptional("CNAME1");
        Optional<String> cName2 = advantajeRecord.getValueOptional("CNAME2");
        Optional<String> cAddress1 = advantajeRecord.getValueOptional("CADDRESS1");
        Optional<String> cAddress2 = advantajeRecord.getValueOptional("CADDRESS2");
        Optional<String> cZipCode = advantajeRecord.getValueOptional("CZIPCODE");
        Optional<String> sVatNumber = advantajeRecord.getValueOptional("CSVATNO");
        Optional<String> cLocality = advantajeRecord.getValueOptional("CLOCALITY");
        Optional<String> cCountry = advantajeRecord.getValueOptional("CCOUNTRY");
        Optional<String> cCouHead = advantajeRecord.getValueOptional("CCOUHEAD");
        Optional<String> cLanguage = advantajeRecord.getValueOptional("CLANGUAGE");
        Optional<Boolean> cisPers = advantajeRecord.getValueOptional("CISPERS");
        Optional<String> cProCategory = advantajeRecord.getValueOptional("CPROCAT");
        Optional<String> cSupplierCategory = advantajeRecord.getValueOptional("CSUPCAT");
        Optional<String> cCustomerCategory = advantajeRecord.getValueOptional("CCUSCAT");
        Optional<String> cCurrency = advantajeRecord.getValueOptional("CCURRENCY");
        Optional<String> cVatRef = advantajeRecord.getValueOptional("CVATREF");
        Optional<String> cVatNumber = advantajeRecord.getValueOptional("CVATNO");
        Optional<String> cVatCategory = advantajeRecord.getValueOptional("CVATCAT");
        Optional<String> cPhoneNumber = advantajeRecord.getValueOptional("CTELNO");
        Optional<String> cFaxNumber = advantajeRecord.getValueOptional("CFAXNO");
//        Optional<> cMemo = advantajeRecord.getValueOptional("CMEMO");
        Optional<Integer> cCustomertLstMno = advantajeRecord.getValueOptional("CCUSLSTMNO");
        Optional<Integer> cSupplierLstMno = advantajeRecord.getValueOptional("CSUPLSTMNO");
        Optional<String> cCustomerVNat1 = advantajeRecord.getValueOptional("CCUSVNAT1");
        Optional<String> cCustomerVNat2 = advantajeRecord.getValueOptional("CCUSVNAT2");
        Optional<Double> cCustomerVatCmp = advantajeRecord.getValueOptional("CCUSVATCMP");
        Optional<String> cSupplierVNat1 = advantajeRecord.getValueOptional("CSUPVNAT1");
        Optional<String> cSupplierVNat2 = advantajeRecord.getValueOptional("CSUPVNAT2");
        Optional<Double> cSupplierVatCmp = advantajeRecord.getValueOptional("CSUPVATCMP");
        Optional<String> cCustomerCtrAcc = advantajeRecord.getValueOptional("CCUSCTRACC");
        Optional<String> cSupplierCtrAcc = advantajeRecord.getValueOptional("CSUPCTRACC");
        Optional<String> cCustomerImputA = advantajeRecord.getValueOptional("CCUSIMPUTA");
        Optional<String> cSupplierImputA = advantajeRecord.getValueOptional("CSUPIMPUTA");
        Optional<String> cSupplierCatComm = advantajeRecord.getValueOptional("CSUPCATCOMM");
        Optional<String> cCountryCode = advantajeRecord.getValueOptional("CCTRYCODE");
        Optional<String> cBankCode = advantajeRecord.getValueOptional("CBANKCODE");
        Optional<String> cBankNumber = advantajeRecord.getValueOptional("CBANKNO");
        Optional<String> cBankIban = advantajeRecord.getValueOptional("CBANKIBAN");
        Optional<String> dbnkQualif = advantajeRecord.getValueOptional("DBNKQUALIF");
        Optional<String> cCustomerPayDelay = advantajeRecord.getValueOptional("CCUSPAYDELAY");
        Optional<Double> cSupplierPayDisc = advantajeRecord.getValueOptional("CSUPPAYDISC");
        Optional<Integer> cSupplierDiscDel = advantajeRecord.getValueOptional("CSUPPDISCDEL");
        Optional<String> cSupplierDiscCalcType = advantajeRecord.getValueOptional("CSUPDISCCALCTYPE");
        Optional<Boolean> cSupplierDiscAdv = advantajeRecord.getValueOptional("CSUPDISCADV");
        Optional<String> cSupplierDiscAdvType = advantajeRecord.getValueOptional("CSUPDISCADVTYPE");
        Optional<Boolean> cSupplierDiscAdvExtra = advantajeRecord.getValueOptional("CSUPDISCADVEXTRA");
        Optional<Double> cSupplierDiscAdvExtraDisc = advantajeRecord.getValueOptional("CSUPDISCADVEXTRADISC");
        Optional<Double> cTempCustomerDebit = advantajeRecord.getValueOptional("CTEMPCUSDEBIT");
        Optional<Double> cTempCustomerCredit = advantajeRecord.getValueOptional("CTEMPCUSCREDIT");
        Optional<Double> cTempSupplierDebit = advantajeRecord.getValueOptional("CTEMPSUPDEBIT");
        Optional<Double> cTempSupplierCredit = advantajeRecord.getValueOptional("CTEMPSUPCREDIT");
        Optional<LocalDateTime> cRemLastDateTime = advantajeRecord.getValueOptional("CREMLASTDATE");
        Optional<Integer> cRemLastLevel = advantajeRecord.getValueOptional("CREMLASTLEVEL");
        Optional<String> cRemCcreMcatStri = advantajeRecord.getValueOptional("CREMCAT");
        Optional<String> cRemStatUsStri = advantajeRecord.getValueOptional("CREMSTATUS");
        Optional<String> cRemSendByStri = advantajeRecord.getValueOptional("CREMSENDBY");
        Optional<Double> cTotInteRestCurr = advantajeRecord.getValueOptional("CTOTINTEREST");
        Optional<String> author = advantajeRecord.getValueOptional("AUTHOR");
        Optional<String> cNationalRegistryId = advantajeRecord.getValueOptional("CNATREGISTRYID");
        Optional<String> cSupplierPayDelay = advantajeRecord.getValueOptional("CSUPPAYDELAY");
        Optional<Boolean> cManualPay = advantajeRecord.getValueOptional("CMANUALPAY");
        Optional<Boolean> cIndepPayee = advantajeRecord.getValueOptional("CINDEPPAYEE");
        Optional<Double> cIndepPayAmn = advantajeRecord.getValueOptional("CINDEPPAYAMN");
        Optional<String> cIndepPImput = advantajeRecord.getValueOptional("CINDEPPIMPUT");
        Optional<String> cBankCivility = advantajeRecord.getValueOptional("CBNKCIVILITY");
        Optional<String> cBankLangCode = advantajeRecord.getValueOptional("CBNKLANGCODE");
        Optional<String> cBankBankDbk = advantajeRecord.getValueOptional("CBNKBANKDBK");
        Optional<Boolean> cBankNeverRegroup = advantajeRecord.getValueOptional("CBNKNEVERREGROUP");
        Optional<Boolean> cFactoring = advantajeRecord.getValueOptional("CFACTORING");
        Optional<String> cFactorId = advantajeRecord.getValueOptional("CFACTORID");
        Optional<Boolean> cBankOrderPay = advantajeRecord.getValueOptional("CBANKORDERPAY");
        Optional<String> cBankOrderPayNumber = advantajeRecord.getValueOptional("CBANKORDERPAYNO");
        Optional<String> cBankOrderMandate = advantajeRecord.getValueOptional("CBANKORDERMANDATE");
        Optional<Boolean> cBankOrderB2B = advantajeRecord.getValueOptional("CBANKORDERB2B");
        Optional<Boolean> cBankOrderMigrTodo = advantajeRecord.getValueOptional("CBANKORDERMIGRTODO");
        Optional<Boolean> cBankOrderBMigrDone = advantajeRecord.getValueOptional("CBANKORDERMIGRDONE");
        Optional<LocalDate> cBankOrderMigrDate = advantajeRecord.getValueOptional("CBANKORDERMIGRDATE");
        Optional<Double> cCustomerPayDisc = advantajeRecord.getValueOptional("CCUSPAYDISC");
        Optional<Integer> cCustomerDiscDel = advantajeRecord.getValueOptional("CCUSPDISCDEL");
        Optional<Boolean> cCustomerDiscAdv = advantajeRecord.getValueOptional("CCUSDISCADV");
        Optional<String> cCustomerDiscAdvType = advantajeRecord.getValueOptional("CCUSDISCADVTYPE");
        Optional<String> cCustomerTempLid = advantajeRecord.getValueOptional("CCUSTEMPLID");
        Optional<String> cSupplierTempLid = advantajeRecord.getValueOptional("CSUPTEMPLID");
        Optional<String> emailAddress = advantajeRecord.getValueOptional("EMAILADDRESS");
        Optional<Boolean> checkEmailIOnv = advantajeRecord.getValueOptional("CHKEMAILINV");
        Optional<String> emailAddressInv = advantajeRecord.getValueOptional("EMAILADDRESSINV");
        Optional<String> httpAddress = advantajeRecord.getValueOptional("HTTPADDRESS");
        Optional<String> cSupplierJob = advantajeRecord.getValueOptional("CSUPPJOB");
        Optional<String> createdBy = advantajeRecord.getValueOptional("CREATEDBY");
        Optional<LocalDateTime> createdOn = advantajeRecord.getValueOptional("CREATEDON");
        Optional<String> modifiedBy = advantajeRecord.getValueOptional("MODIFIEDBY");
        Optional<LocalDateTime> modifiedOn = advantajeRecord.getValueOptional("MODIFIEDON");
        Optional<String> trftStatus = advantajeRecord.getValueOptional("TRFTSTATUS");
        Optional<String> stationId = advantajeRecord.getValueOptional("STATIONID");
        Optional<String> cBusinessNumber = advantajeRecord.getValueOptional("CBUSINESSNO");
        Optional<Boolean> cCustomerInWarning = advantajeRecord.getValueOptional("CCUSISWARNING");
        Optional<Boolean> cSupplierInWarning = advantajeRecord.getValueOptional("CSUPISWARNING");
        Optional<Boolean> cCustomerReadOnly = advantajeRecord.getValueOptional("CCUSISREADONL");
        Optional<Boolean> cSupplierReadOnly = advantajeRecord.getValueOptional("CSUPISREADONL");
        Optional<Boolean> cCustomerBlocked = advantajeRecord.getValueOptional("CCUSISBLOCK");
        Optional<Boolean> cSupplierBlocked = advantajeRecord.getValueOptional("CSUPISBLOCK");
        Optional<Boolean> cCustomerSecret = advantajeRecord.getValueOptional("CCUSISSECRET");
        Optional<Boolean> cSupplierSecret = advantajeRecord.getValueOptional("CSUPISSECRET");
        Optional<Boolean> cCustomerSleeping = advantajeRecord.getValueOptional("CCUSSLEEPING");
        Optional<Boolean> cSupplierSleeping = advantajeRecord.getValueOptional("CSUPSLEEPING");
        Optional<String> cBankTypePay = advantajeRecord.getValueOptional("CBNKTYPEPAY");
        Optional<LocalDateTime> boardDateTime = advantajeRecord.getValueOptional("BOARDDATE");
        Optional<Boolean> boardPublic = advantajeRecord.getValueOptional("BOARDPUBLIC");
        Optional<String> fiscalControl = advantajeRecord.getValueOptional("FISCALCONTROL");
        Optional<String> fiscalControlPhoneNumber = advantajeRecord.getValueOptional("FISCALCTRLTELNO");
        Optional<String> folderId = advantajeRecord.getValueOptional("FOLDERID");
        Optional<LocalDateTime> fYearEndDateTime = advantajeRecord.getValueOptional("FYEAREND");
        Optional<Boolean> manFolder = advantajeRecord.getValueOptional("MANFOLDER");
        Optional<Boolean> manReport = advantajeRecord.getValueOptional("MANREPORT");
        Optional<String> revisor = advantajeRecord.getValueOptional("REVISOR");
        Optional<String> userResp = advantajeRecord.getValueOptional("USERRESP");
        Optional<String> vatControl = advantajeRecord.getValueOptional("VATCONTROL");
        Optional<String> vatControlPhoneNumber = advantajeRecord.getValueOptional("VATCTRLTELNO");
        Optional<String> vatType = advantajeRecord.getValueOptional("VATTYPE");
        Optional<String> tremExt = advantajeRecord.getValueOptional("TREMEXT");
        Optional<String> trftSite = advantajeRecord.getValueOptional("TRFTSITE");
        Optional<Integer> trftVers = advantajeRecord.getValueOptional("TRFTVERS");
        Optional<Boolean> decSiteSelected = advantajeRecord.getValueOptional("DECSITESELECTED");
        Optional<Integer> cExtRef = advantajeRecord.getValueOptional("CEXTREF");
        Optional<String> cKeyId = advantajeRecord.getValueOptional("CKEYID");
        Optional<String> cEnsignLink = advantajeRecord.getValueOptional("CENSIGNLINK");
        Optional<String> c28150Sport = advantajeRecord.getValueOptional("C28150SPORT");
        Optional<String> crmCustomer = advantajeRecord.getValueOptional("CRMCUS");
        Optional<String> crmSupplier = advantajeRecord.getValueOptional("CRMSUP");
        Optional<String> uniqueId = advantajeRecord.getValueOptional("UNIQUEID");
        Optional<Integer> cIdDbFact = advantajeRecord.getValueOptional("CIDDBFACT");
        Optional<String> cCustomerEInvRecMeth = advantajeRecord.getValueOptional("CCUSEINVRECMETH");
        Optional<String> cCustomerEInvSystem = advantajeRecord.getValueOptional("CCUSEINVSYSTEM");
        Optional<LocalDateTime> cCustomerEInvFromDateTime = advantajeRecord.getValueOptional("CCUSEINVFROMDATE");
        Optional<String> cSupplierEInvRecMeth = advantajeRecord.getValueOptional("CSUPEINVRECMETH");
        Optional<String> cSupplierEInvSystem = advantajeRecord.getValueOptional("CSUPEINVSYSTEM");
        Optional<LocalDateTime> cSupplierEInvFromDateTime = advantajeRecord.getValueOptional("CSUPEINVFROMDATE");
        Optional<String> cCustomerInviteStatus = advantajeRecord.getValueOptional("CCUSINVITESTATUS");
        Optional<String> eInvId = advantajeRecord.getValueOptional("EINVID");
        Optional<String> cSupplierEComId = advantajeRecord.getValueOptional("CSUPECOM_ID");
        Optional<String> cCustomerEComId = advantajeRecord.getValueOptional("CCUSECOM_ID");
//        Optional<> cAcqTemplate = advantajeRecord.getValueOptional("CACQTEMPLATE");
        Optional<LocalDateTime> cCustomerEInvLastChangeDateTime = advantajeRecord.getValueOptional("CCUSEINVLASTCHG");
        Optional<LocalDateTime> cSupplierEInvLastChangeDateTime = advantajeRecord.getValueOptional("CSUPEINVLASTCHG");
        Optional<Boolean> cCustomerEInvExclude = advantajeRecord.getValueOptional("CCUSEINVEXCLUDE");
        Optional<Boolean> cSupplierEInvExclude = advantajeRecord.getValueOptional("CSUPEINVEXCLUDE");
        Optional<String> cSupplierInviteStatus = advantajeRecord.getValueOptional("CSUPINVITESTATUS");
        Optional<Integer> freedelityId = advantajeRecord.getValueOptional("FREEDELITYID");
        Optional<String> cManecomId = advantajeRecord.getValueOptional("CMANECOM_ID");
        Optional<Boolean> dgdComplex = advantajeRecord.getValueOptional("DGDCOMPLEX");
        Optional<String> cCustomerDematKeyWord = advantajeRecord.getValueOptional("CCUSDEMATKEYWORD");
        Optional<String> cSupplierDematKeyWord = advantajeRecord.getValueOptional("CSUPDEMATKEYWORD");

        BobCompany bobCompany = new BobCompany();
        bobCompany.setcId(cId);
        bobCompany.setcCustomerTypeOptional(cCustomerType);
        bobCompany.setcSupplierTypeOptional(cSupplierType);
        bobCompany.setcName1(cName1.orElse(null));
        bobCompany.setcName2Optional(cName2);
        bobCompany.setcAddress1Optional(cAddress1);
        bobCompany.setcAddress2Optional(cAddress2);
        bobCompany.setcZipCodeOptional(cZipCode);
        bobCompany.setsVatNumberOptional(sVatNumber);
        bobCompany.setcLocalityOptional(cLocality);
        bobCompany.setcCountryOptional(cCountry);
        bobCompany.setcCouHeadOptional(cCouHead);
        bobCompany.setcLanguageOptional(cLanguage);
        bobCompany.setCisPersOptional(cisPers);
        bobCompany.setcProCategoryOptional(cProCategory);
        bobCompany.setcSupplierCategoryOptional(cSupplierCategory);
        bobCompany.setcCustomerCategoryOptional(cCustomerCategory);
        bobCompany.setcCurrencyOptional(cCurrency);
        bobCompany.setcVatRefOptional(cVatRef);
        bobCompany.setcVatNumberOptional(cVatNumber);
        bobCompany.setcVatCategoryOptional(cVatCategory);
        bobCompany.setcPhoneNumberOptional(cPhoneNumber);
        bobCompany.setcFaxNumberOptional(cFaxNumber);
//        bobCompany.setcMemoOptional(cMemo);
        bobCompany.setcCustomertLstMnoOptional(cCustomertLstMno);
        bobCompany.setcSupplierLstMnoOptional(cSupplierLstMno);
        bobCompany.setcCustomerVNat1Optional(cCustomerVNat1);
        bobCompany.setcCustomerVNat2Optional(cCustomerVNat2);
        bobCompany.setcCustomerVatCmpOptional(cCustomerVatCmp);
        bobCompany.setcSupplierVNat1Optional(cSupplierVNat1);
        bobCompany.setcSupplierVNat2Optional(cSupplierVNat2);
        bobCompany.setcSupplierVatCmpOptional(cSupplierVatCmp);
        bobCompany.setcCustomerCtrAccOptional(cCustomerCtrAcc);
        bobCompany.setcSupplierCtrAccOptional(cSupplierCtrAcc);
        bobCompany.setcCustomerImputAOptional(cCustomerImputA);
        bobCompany.setcSupplierImputAOptional(cSupplierImputA);
        bobCompany.setcSupplierCatCommOptional(cSupplierCatComm);
        bobCompany.setcCountryCodeOptional(cCountryCode);
        bobCompany.setcBankCodeOptional(cBankCode);
        bobCompany.setcBankNumberOptional(cBankNumber);
        bobCompany.setcBankIbanOptional(cBankIban);
        bobCompany.setDbnkQualifOptional(dbnkQualif);
        bobCompany.setcCustomerPayDelayOptional(cCustomerPayDelay);
        bobCompany.setcSupplierPayDiscOptional(cSupplierPayDisc);
        bobCompany.setcSupplierDiscDelOptional(cSupplierDiscDel);
        bobCompany.setcSupplierDiscCalcTypeOptional(cSupplierDiscCalcType);
        bobCompany.setcSupplierDiscAdvOptional(cSupplierDiscAdv);
        bobCompany.setcSupplierDiscAdvTypeOptional(cSupplierDiscAdvType);
        bobCompany.setcSupplierDiscAdvExtraOptional(cSupplierDiscAdvExtra);
        bobCompany.setcSupplierDiscAdvExtraDiscOptional(cSupplierDiscAdvExtraDisc);
        bobCompany.setcTempCustomerDebitOptional(cTempCustomerDebit);
        bobCompany.setcTempCustomerCreditOptional(cTempCustomerCredit);
        bobCompany.setcTempSupplierDebitOptional(cTempSupplierDebit);
        bobCompany.setcTempSupplierCreditOptional(cTempSupplierCredit);
        bobCompany.setcRemLastDateTimeOptional(cRemLastDateTime);
        bobCompany.setcRemLastLevelOptional(cRemLastLevel);
        bobCompany.setcRemCcreMcatStriOptional(cRemCcreMcatStri);
        bobCompany.setcRemStatUsStriOptional(cRemStatUsStri);
        bobCompany.setcRemSendByStriOptional(cRemSendByStri);
        bobCompany.setcTotInteRestCurrOptional(cTotInteRestCurr);
        bobCompany.setAuthorOptional(author);
        bobCompany.setcNationalRegistryIdOptional(cNationalRegistryId);
        bobCompany.setcSupplierPayDelayOptional(cSupplierPayDelay);
        bobCompany.setcManualPayOptional(cManualPay);
        bobCompany.setcIndepPayeeOptional(cIndepPayee);
        bobCompany.setcIndepPayAmnOptional(cIndepPayAmn);
        bobCompany.setcIndepPImputOptional(cIndepPImput);
        bobCompany.setcBankCivilityOptional(cBankCivility);
        bobCompany.setcBankLangCodeOptional(cBankLangCode);
        bobCompany.setcBankBankDbkOptional(cBankBankDbk);
        bobCompany.setcBankNeverRegroupOptional(cBankNeverRegroup);
        bobCompany.setcFactoringOptional(cFactoring);
        bobCompany.setcFactorIdOptional(cFactorId);
        bobCompany.setcBankOrderPayOptional(cBankOrderPay);
        bobCompany.setcBankOrderPayNumberOptional(cBankOrderPayNumber);
        bobCompany.setcBankOrderMandateOptional(cBankOrderMandate);
        bobCompany.setcBankOrderB2BOptional(cBankOrderB2B);
        bobCompany.setcBankOrderMigrTodoOptional(cBankOrderMigrTodo);
        bobCompany.setcBankOrderBMigrDoneOptional(cBankOrderBMigrDone);
        bobCompany.setcBankOrderMigrDateOptional(cBankOrderMigrDate);
        bobCompany.setcCustomerPayDiscOptional(cCustomerPayDisc);
        bobCompany.setcCustomerDiscDelOptional(cCustomerDiscDel);
        bobCompany.setcCustomerDiscAdvOptional(cCustomerDiscAdv);
        bobCompany.setcCustomerDiscAdvTypeOptional(cCustomerDiscAdvType);
        bobCompany.setcCustomerTempLidOptional(cCustomerTempLid);
        bobCompany.setcSupplierTempLidOptional(cSupplierTempLid);
        bobCompany.setEmailAddressOptional(emailAddress);
        bobCompany.setCheckEmailIOnvOptional(checkEmailIOnv);
        bobCompany.setEmailAddressInvOptional(emailAddressInv);
        bobCompany.setHttpAddressOptional(httpAddress);
        bobCompany.setcSupplierJobOptional(cSupplierJob);
        bobCompany.setCreatedByOptional(createdBy);
        bobCompany.setCreatedOnOptional(createdOn);
        bobCompany.setModifiedByOptional(modifiedBy);
        bobCompany.setModifiedOnOptional(modifiedOn);
        bobCompany.setTrftStatusOptional(trftStatus);
        bobCompany.setStationIdOptional(stationId);
        bobCompany.setcBusinessNumberOptional(cBusinessNumber);
        bobCompany.setcCustomerInWarningOptional(cCustomerInWarning);
        bobCompany.setcSupplierInWarningOptional(cSupplierInWarning);
        bobCompany.setcCustomerReadOnlyOptional(cCustomerReadOnly);
        bobCompany.setcSupplierReadOnlyOptional(cSupplierReadOnly);
        bobCompany.setcCustomerBlockedOptional(cCustomerBlocked);
        bobCompany.setcSupplierBlockedOptional(cSupplierBlocked);
        bobCompany.setcCustomerSecretOptional(cCustomerSecret);
        bobCompany.setcSupplierSecretOptional(cSupplierSecret);
        bobCompany.setcCustomerSleepingOptional(cCustomerSleeping);
        bobCompany.setcSupplierSleepingOptional(cSupplierSleeping);
        bobCompany.setcBankTypePayOptional(cBankTypePay);
        bobCompany.setBoardDateTimeOptional(boardDateTime);
        bobCompany.setBoardPublicOptional(boardPublic);
        bobCompany.setFiscalControlOptional(fiscalControl);
        bobCompany.setFiscalControlPhoneNumberOptional(fiscalControlPhoneNumber);
        bobCompany.setFolderIdOptional(folderId);
        bobCompany.setfYearEndDateTimeOptional(fYearEndDateTime);
        bobCompany.setManFolderOptional(manFolder);
        bobCompany.setManReportOptional(manReport);
        bobCompany.setRevisorOptional(revisor);
        bobCompany.setUserRespOptional(userResp);
        bobCompany.setVatControlOptional(vatControl);
        bobCompany.setVatControlPhoneNumberOptional(vatControlPhoneNumber);
        bobCompany.setVatTypeOptional(vatType);
        bobCompany.setTremExtOptional(tremExt);
        bobCompany.setTrftSiteOptional(trftSite);
        bobCompany.setTrftVersOptional(trftVers);
        bobCompany.setDecSiteSelectedOptional(decSiteSelected);
        bobCompany.setcExtRefOptional(cExtRef);
        bobCompany.setcKeyIdOptional(cKeyId);
        bobCompany.setcEnsignLinkOptional(cEnsignLink);
        bobCompany.setC28150SportOptional(c28150Sport);
        bobCompany.setCrmCustomerOptional(crmCustomer);
        bobCompany.setCrmSupplierOptional(crmSupplier);
        bobCompany.setUniqueIdOptional(uniqueId);
        bobCompany.setcIdDbFactOptional(cIdDbFact);
        bobCompany.setcCustomerEInvRecMethOptional(cCustomerEInvRecMeth);
        bobCompany.setcCustomerEInvSystemOptional(cCustomerEInvSystem);
        bobCompany.setcCustomerEInvFromDateTimeOptional(cCustomerEInvFromDateTime);
        bobCompany.setcSupplierEInvRecMethOptional(cSupplierEInvRecMeth);
        bobCompany.setcSupplierEInvSystemOptional(cSupplierEInvSystem);
        bobCompany.setcSupplierEInvFromDateTimeOptional(cSupplierEInvFromDateTime);
        bobCompany.setcCustomerInviteStatusOptional(cCustomerInviteStatus);
        bobCompany.seteInvIdOptional(eInvId);
        bobCompany.setcSupplierEComIdOptional(cSupplierEComId);
        bobCompany.setcCustomerEComIdOptional(cCustomerEComId);
//        bobCompany.setcAcqTemplateOptional(cAcqTemplate);
        bobCompany.setcCustomerEInvLastChangeDateTimeOptional(cCustomerEInvLastChangeDateTime);
        bobCompany.setcSupplierEInvLastChangeDateTimeOptional(cSupplierEInvLastChangeDateTime);
        bobCompany.setcCustomerEInvExcludeOptional(cCustomerEInvExclude);
        bobCompany.setcSupplierEInvExcludeOptional(cSupplierEInvExclude);
        bobCompany.setcSupplierInviteStatusOptional(cSupplierInviteStatus);
        bobCompany.setFreedelityIdOptional(freedelityId);
        bobCompany.setcManecomIdOptional(cManecomId);
        bobCompany.setDgdComplexOptional(dgdComplex);
        bobCompany.setcCustomerDematKeyWordOptional(cCustomerDematKeyWord);
        bobCompany.setcSupplierDematKeyWordOptional(cSupplierDematKeyWord);

        return bobCompany;
    }
}
