/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.controller.jampad;

import be.yildizgames.module.controller.ControllerModel;
import be.yildizgames.module.controller.internal.ControllerRunner;
import be.yildizgames.module.controller.jampad.JampadControllerModelMapper;
import com.studiohartman.jamepad.ControllerManager;
import com.studiohartman.jamepad.ControllerState;

class JamPadControllerRunner
extends ControllerRunner {
    private final int id;
    private final ControllerManager controllerManager;
    private ControllerState currState;
    private final JampadControllerModelMapper modelMapper = new JampadControllerModelMapper();

    JamPadControllerRunner(int id, ControllerManager controllerManager) {
        this.id = id;
        this.controllerManager = controllerManager;
        this.currState = controllerManager.getState(this.id);
    }

    @Override
    protected boolean button1() {
        return this.currState.a;
    }

    @Override
    protected boolean button2() {
        return this.currState.b;
    }

    @Override
    protected boolean button3() {
        return this.currState.x;
    }

    @Override
    protected boolean button4() {
        return this.currState.y;
    }

    @Override
    protected boolean buttonL1() {
        return this.currState.lb;
    }

    @Override
    protected boolean buttonL2() {
        return this.currState.leftTrigger > 0.0f;
    }

    @Override
    protected boolean buttonR1() {
        return this.currState.rb;
    }

    @Override
    protected boolean buttonR2() {
        return this.currState.rightTrigger > 0.0f;
    }

    @Override
    protected boolean buttonStart() {
        return this.currState.start;
    }

    @Override
    protected boolean buttonSelect() {
        return this.currState.back;
    }

    @Override
    protected boolean down() {
        return this.currState.dpadDown;
    }

    @Override
    protected boolean up() {
        return this.currState.dpadUp;
    }

    @Override
    protected boolean right() {
        return this.currState.dpadRight;
    }

    @Override
    protected boolean left() {
        return this.currState.dpadLeft;
    }

    @Override
    protected final float leftStickVertical() {
        return this.currState.leftStickY;
    }

    @Override
    protected final float leftStickHorizontal() {
        return this.currState.leftStickX;
    }

    @Override
    public boolean isConnected() {
        this.currState = this.controllerManager.getState(this.id);
        return this.currState.isConnected;
    }

    @Override
    public ControllerModel getModel() {
        System.out.println(this.currState.controllerType);
        return this.modelMapper.map(this.currState.controllerType);
    }
}

