/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.database.derby;

import be.yildizgames.module.database.BaseDatabaseSystem;
import be.yildizgames.module.database.DatabaseConnectionProviderFactory;
import be.yildizgames.module.database.DatabaseSystem;
import be.yildizgames.module.database.DriverProvider;
import be.yildizgames.module.database.QueryBuilder;
import be.yildizgames.module.database.derby.DerbyQueryBuilder;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.jooq.SQLDialect;

public class DerbySystem
extends BaseDatabaseSystem {
    public static final String KEY = "derby-file";
    private final DriverProvider driver = EmbeddedDriver::new;

    private DerbySystem() {
        super("jdbc:derby:target/database/${0};create=true");
    }

    public static void support() {
        DatabaseConnectionProviderFactory.getInstance().addSystem(KEY, (DatabaseSystem)new DerbySystem());
    }

    public SQLDialect getDialect() {
        return SQLDialect.DERBY;
    }

    public String getDriver() {
        return "org.apache.derby.jdbc.EmbeddedDriver";
    }

    public DriverProvider getDriverProvider() {
        return this.driver;
    }

    public QueryBuilder createBuilder() {
        return new DerbyQueryBuilder();
    }

    public boolean requirePool() {
        return false;
    }
}

