/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.database;

import be.yildizgames.common.logging.LogFactory;
import be.yildizgames.module.database.DataBaseConnectionProvider;
import be.yildizgames.module.database.DatabaseSystem;
import be.yildizgames.module.database.DbProperties;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;

final class C3P0ConnectionProvider
extends DataBaseConnectionProvider {
    private static final Logger LOGGER = LogFactory.getInstance().getLogger(C3P0ConnectionProvider.class);
    private static final int ONE_HOUR = 3600;
    private static final int HALF_HOUR = 1800;
    private final ComboPooledDataSource cpds;
    private boolean open = false;

    C3P0ConnectionProvider(DatabaseSystem system, DbProperties properties, boolean root) throws SQLException {
        super(system, properties, root);
        System.setProperty("com.mchange.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL", "WARNING");
        System.setProperty("com.mchange.v2.log.MLog", "com.mchange.v2.log.FallbackMLog");
        this.cpds = new ComboPooledDataSource();
        try {
            this.cpds.setDriverClass(system.getDriver());
        }
        catch (Exception e) {
            LOGGER.error("Error in pool", (Throwable)e);
            throw new SQLException("Cannot load pool driver.", e);
        }
        this.cpds.setJdbcUrl(this.getUri());
        this.cpds.setUser(this.getLogin());
        this.cpds.setPassword(this.getPassword());
        this.cpds.setMaxIdleTime(3600);
        this.cpds.setMaxIdleTimeExcessConnections(1800);
        this.cpds.setAutoCommitOnClose(true);
    }

    C3P0ConnectionProvider(DatabaseSystem system, DbProperties properties) throws SQLException {
        this(system, properties, false);
    }

    @Override
    protected Connection getConnectionImpl() throws SQLException {
        return this.cpds.getConnection();
    }

    @Override
    public void close() {
        if (this.open) {
            this.cpds.close();
            this.open = false;
            LOGGER.info("Closed database connection pool.");
        }
    }
}

