/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.database;

import be.yildizgames.common.exception.implementation.ImplementationException;
import be.yildizgames.common.logging.LogFactory;
import be.yildizgames.module.database.DatabaseSystem;
import be.yildizgames.module.database.DbProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.jdbcdslog.ConnectionLoggingProxy;
import org.jooq.SQLDialect;
import org.slf4j.Logger;

public abstract class DataBaseConnectionProvider
implements AutoCloseable {
    private static final Logger LOGGER = LogFactory.getInstance().getLogger(DataBaseConnectionProvider.class);
    private final DatabaseSystem system;
    private String uri;
    private final String login;
    private final String password;
    private boolean debug;

    protected DataBaseConnectionProvider(DatabaseSystem system, DbProperties properties, boolean root) {
        ImplementationException.throwForNull((Object)system);
        ImplementationException.throwForNull((Object)properties);
        Properties p = new Properties(System.getProperties());
        p.put("com.mchange.v2.log.MLog", "com.mchange.v2.log.FallbackMLog");
        p.put("com.mchange.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL", "info");
        p.put("org.jooq.no-logo", "true");
        System.setProperties(p);
        this.login = root ? properties.getDbRootUser() : properties.getDbUser();
        this.password = root ? properties.getDbRootPassword() : properties.getDbPassword();
        this.uri = system.getUrl(properties);
        this.system = system;
        assert (this.invariant());
    }

    public final void setDebugMode() {
        this.debug = true;
    }

    public final void sanity() throws SQLException {
        LOGGER.info("Checking database connection...");
        try (Connection c = this.getConnection();){
            LOGGER.info("Checking database connection successful.");
        }
        catch (SQLException e) {
            LOGGER.error("Database connection failed.");
            throw e;
        }
    }

    public final Connection getConnection() throws SQLException {
        Connection c = this.getConnectionImpl();
        if (this.debug) {
            c = ConnectionLoggingProxy.wrap((Connection)c);
        }
        return c;
    }

    public final SQLDialect getDialect() {
        return this.system.getDialect();
    }

    public final String getDriver() {
        return this.system.getDriver();
    }

    public final String getUri() {
        return this.uri;
    }

    protected final DatabaseSystem getSystem() {
        return this.system;
    }

    protected final String getLogin() {
        return this.login;
    }

    protected final String getPassword() {
        return this.password;
    }

    protected final boolean isDebug() {
        return this.debug;
    }

    protected abstract Connection getConnectionImpl() throws SQLException;

    private boolean invariant() {
        if (this.login == null) {
            LOGGER.error("login cannot be null.");
            return false;
        }
        if (this.password == null) {
            LOGGER.error("password cannot be null.");
            return false;
        }
        if (this.uri == null) {
            LOGGER.error("uri cannot be null.");
            return false;
        }
        return true;
    }
}

