/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.database;

import be.yildizgames.common.exception.implementation.ImplementationException;
import be.yildizgames.common.exception.technical.InitializationException;
import be.yildizgames.module.database.C3P0ConnectionProvider;
import be.yildizgames.module.database.DataBaseConnectionProvider;
import be.yildizgames.module.database.DatabaseSystem;
import be.yildizgames.module.database.DbProperties;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DatabaseConnectionProviderFactory {
    private static final DatabaseConnectionProviderFactory INSTANCE = new DatabaseConnectionProviderFactory();
    private final Map<String, DatabaseSystem> systems = new HashMap<String, DatabaseSystem>();

    private DatabaseConnectionProviderFactory() {
    }

    public static DatabaseConnectionProviderFactory getInstance() {
        return INSTANCE;
    }

    public final void addSystem(String key, DatabaseSystem system) {
        this.systems.put(key, system);
    }

    public final DataBaseConnectionProvider create(DbProperties properties) throws SQLException {
        ImplementationException.throwForNull((Object)properties);
        DatabaseSystem system = Optional.ofNullable(this.systems.get(properties.getSystem())).orElseThrow(() -> new InitializationException(properties.getSystem()));
        return new C3P0ConnectionProvider(system, properties);
    }

    public final DataBaseConnectionProvider createWithHighPrivilege(DbProperties properties) throws SQLException {
        ImplementationException.throwForNull((Object)properties);
        DatabaseSystem system = Optional.ofNullable(this.systems.get(properties.getSystem())).orElseThrow(() -> new InitializationException(properties.getSystem()));
        return new C3P0ConnectionProvider(system, properties, true);
    }
}

