/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.database;

public interface DbProperties {
    public String getDbUser();

    public int getDbPort();

    public String getDbPassword();

    public String getDbHost();

    public String getDbName();

    public String getSystem();

    public String getDbRootUser();

    public String getDbRootPassword();

    public static class DbPropertiesInvariant {
        private DbPropertiesInvariant() {
        }

        public static void check(String user, String password, String rootUser, String rootPassword, String database, String host, int port, String system) {
            DbPropertiesInvariant.checkUser(user);
            DbPropertiesInvariant.checkPassword(password);
            DbPropertiesInvariant.checkRootUser(rootUser);
            DbPropertiesInvariant.checkRootPassword(rootPassword);
            DbPropertiesInvariant.checkDatabase(database);
            DbPropertiesInvariant.checkHost(host);
            DbPropertiesInvariant.checkPort(port);
            DbPropertiesInvariant.checkSystem(system);
        }

        private static void checkUser(String user) {
            if (user == null) {
                throw new NullPointerException("User is null.");
            }
        }

        private static void checkPassword(String password) {
            if (password == null) {
                throw new NullPointerException("Password is null.");
            }
        }

        private static void checkRootUser(String user) {
            if (user == null) {
                throw new NullPointerException("User root is null.");
            }
        }

        private static void checkRootPassword(String password) {
            if (password == null) {
                throw new NullPointerException("Password root is null.");
            }
        }

        private static void checkDatabase(String database) {
            if (database == null) {
                throw new NullPointerException("database is null.");
            }
        }

        private static void checkHost(String host) {
            if (host == null) {
                throw new NullPointerException("Host is null.");
            }
        }

        private static void checkPort(int port) {
            if (port < 0 || port > 65635) {
                throw new IllegalArgumentException("Port must be between 0 and 65635, value is " + port);
            }
        }

        private static void checkSystem(String system) {
            if (system == null) {
                throw new NullPointerException("System is null.");
            }
        }
    }
}

